/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.exceptions;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.httpclient.HttpMethod;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.exceptions.SwiftConnectionException;

public class SwiftInvalidResponseException
extends SwiftConnectionException {
    public final int statusCode;
    public final String operation;
    public final URI uri;
    public final String body;

    public SwiftInvalidResponseException(String message, int statusCode, String operation, URI uri) {
        super(message);
        this.statusCode = statusCode;
        this.operation = operation;
        this.uri = uri;
        this.body = "";
    }

    public SwiftInvalidResponseException(String message, String operation, URI uri, HttpMethod method) {
        super(message);
        String bodyAsString;
        this.statusCode = method.getStatusCode();
        this.operation = operation;
        this.uri = uri;
        try {
            bodyAsString = method.getResponseBodyAsString();
            if (bodyAsString == null) {
                bodyAsString = "";
            }
        }
        catch (IOException e) {
            bodyAsString = "";
        }
        this.body = bodyAsString;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getOperation() {
        return this.operation;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getBody() {
        return this.body;
    }

    public String exceptionTitle() {
        return "Invalid Response";
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.exceptionTitle());
        msg.append(": ");
        msg.append(this.getMessage());
        msg.append("  ");
        msg.append(this.operation);
        msg.append(" ");
        msg.append(this.uri);
        msg.append(" => ");
        msg.append(this.statusCode);
        if (this.body != null && !this.body.isEmpty()) {
            msg.append(" : ");
            msg.append(this.body);
        }
        return msg.toString();
    }
}

