/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.PathExistsException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.PathIOException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.PathNotFoundException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.FsCommand;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Mkdir
extends FsCommand {
    public static final String NAME = "mkdir";
    public static final String USAGE = "[-p] <path> ...";
    public static final String DESCRIPTION = "Create a directory in specified location.\n-p: Do not fail if the directory already exists";
    private boolean createParents;

    Mkdir() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Mkdir.class, "-mkdir");
    }

    @Override
    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "p");
        cf.parse(args);
        this.createParents = cf.getOpt("p");
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            if (!this.createParents) {
                throw new PathExistsException(item.toString());
            }
        } else {
            throw new PathIsNotDirectoryException(item.toString());
        }
    }

    @Override
    protected void processNonexistentPath(PathData item) throws IOException {
        if (!this.createParents && !item.fs.exists(new Path(item.path.toString()).getParent())) {
            throw new PathNotFoundException(item.toString());
        }
        if (!item.fs.mkdirs(item.path)) {
            throw new PathIOException(item.toString());
        }
    }
}

