/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.StorageStatistics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UnionStorageStatistics
extends StorageStatistics {
    private final StorageStatistics[] stats;

    public UnionStorageStatistics(String name, StorageStatistics[] stats) {
        super(name);
        Preconditions.checkArgument(name != null, "The name of union storage statistics can not be null!");
        Preconditions.checkArgument(stats != null, "The stats of union storage statistics can not be null!");
        for (StorageStatistics stat : stats) {
            Preconditions.checkArgument(stat != null, "The stats of union storage statistics can not have null element!");
        }
        this.stats = stats;
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        return new LongStatisticIterator();
    }

    @Override
    public Long getLong(String key) {
        for (StorageStatistics stat : this.stats) {
            Long val = stat.getLong(key);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public boolean isTracked(String key) {
        for (StorageStatistics stat : this.stats) {
            if (!stat.isTracked(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        for (StorageStatistics stat : this.stats) {
            stat.reset();
        }
    }

    private class LongStatisticIterator
    implements Iterator<StorageStatistics.LongStatistic> {
        private int statIdx = 0;
        private Iterator<StorageStatistics.LongStatistic> cur = null;

        LongStatisticIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.getIter() != null;
        }

        private Iterator<StorageStatistics.LongStatistic> getIter() {
            while (this.cur == null || !this.cur.hasNext()) {
                if (UnionStorageStatistics.this.stats.length >= this.statIdx) {
                    return null;
                }
                this.cur = UnionStorageStatistics.this.stats[this.statIdx++].getLongStatistics();
            }
            return this.cur;
        }

        @Override
        public StorageStatistics.LongStatistic next() {
            Iterator<StorageStatistics.LongStatistic> iter = this.getIter();
            if (iter == null) {
                throw new NoSuchElementException();
            }
            return iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

