/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.WritableFactories;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.WritableFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.WritableUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FsServerDefaults
implements Writable {
    private long blockSize;
    private int bytesPerChecksum;
    private int writePacketSize;
    private short replication;
    private int fileBufferSize;
    private boolean encryptDataTransfer;
    private long trashInterval;
    private DataChecksum.Type checksumType;

    public FsServerDefaults() {
    }

    public FsServerDefaults(long blockSize, int bytesPerChecksum, int writePacketSize, short replication, int fileBufferSize, boolean encryptDataTransfer, long trashInterval, DataChecksum.Type checksumType) {
        this.blockSize = blockSize;
        this.bytesPerChecksum = bytesPerChecksum;
        this.writePacketSize = writePacketSize;
        this.replication = replication;
        this.fileBufferSize = fileBufferSize;
        this.encryptDataTransfer = encryptDataTransfer;
        this.trashInterval = trashInterval;
        this.checksumType = checksumType;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public int getWritePacketSize() {
        return this.writePacketSize;
    }

    public short getReplication() {
        return this.replication;
    }

    public int getFileBufferSize() {
        return this.fileBufferSize;
    }

    public boolean getEncryptDataTransfer() {
        return this.encryptDataTransfer;
    }

    public long getTrashInterval() {
        return this.trashInterval;
    }

    public DataChecksum.Type getChecksumType() {
        return this.checksumType;
    }

    @Override
    @InterfaceAudience.Private
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.blockSize);
        out.writeInt(this.bytesPerChecksum);
        out.writeInt(this.writePacketSize);
        out.writeShort(this.replication);
        out.writeInt(this.fileBufferSize);
        WritableUtils.writeEnum(out, this.checksumType);
    }

    @Override
    @InterfaceAudience.Private
    public void readFields(DataInput in) throws IOException {
        this.blockSize = in.readLong();
        this.bytesPerChecksum = in.readInt();
        this.writePacketSize = in.readInt();
        this.replication = in.readShort();
        this.fileBufferSize = in.readInt();
        this.checksumType = WritableUtils.readEnum(in, DataChecksum.Type.class);
    }

    static {
        WritableFactories.setFactory(FsServerDefaults.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new FsServerDefaults();
            }
        });
    }
}

