/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto;

import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public enum CryptoProtocolVersion {
    UNKNOWN("Unknown", 1),
    ENCRYPTION_ZONES("Encryption zones", 2);

    private final String description;
    private final int version;
    private Integer unknownValue = null;
    private static CryptoProtocolVersion[] supported;

    public static CryptoProtocolVersion[] supported() {
        return supported;
    }

    private CryptoProtocolVersion(String description, int version) {
        this.description = description;
        this.version = version;
    }

    public static boolean supports(CryptoProtocolVersion version) {
        if (version.getVersion() == UNKNOWN.getVersion()) {
            return false;
        }
        for (CryptoProtocolVersion v : CryptoProtocolVersion.values()) {
            if (v.getVersion() != version.getVersion()) continue;
            return true;
        }
        return false;
    }

    public void setUnknownValue(int unknown) {
        this.unknownValue = unknown;
    }

    public int getUnknownValue() {
        return this.unknownValue;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return "CryptoProtocolVersion{description='" + this.description + '\'' + ", version=" + this.version + ", unknownValue=" + this.unknownValue + '}';
    }

    static {
        supported = new CryptoProtocolVersion[]{ENCRYPTION_ZONES};
    }
}

