/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.sym;

import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.sym.Name;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.sym.Name1;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.sym.Name2;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.sym.Name3;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.sym.NameN;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.htrace.fasterxml.jackson.core.util.InternCache;

public final class BytesToNameCanonicalizer {
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    private static final int MAX_ENTRIES_FOR_REUSE = 6000;
    private static final int MAX_COLL_CHAIN_LENGTH = 100;
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    protected final BytesToNameCanonicalizer _parent;
    protected final AtomicReference<TableInfo> _tableInfo;
    private final int _seed;
    protected boolean _intern;
    protected final boolean _failOnDoS;
    protected int _count;
    protected int _longestCollisionList;
    protected int _hashMask;
    protected int[] _hash;
    protected Name[] _mainNames;
    protected Bucket[] _collList;
    protected int _collCount;
    protected int _collEnd;
    private transient boolean _needRehash;
    private boolean _hashShared;
    private boolean _namesShared;
    private boolean _collListShared;
    protected BitSet _overflows;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;

    private BytesToNameCanonicalizer(int sz, boolean intern, int seed, boolean failOnDoS) {
        this._parent = null;
        this._seed = seed;
        this._intern = intern;
        this._failOnDoS = failOnDoS;
        if (sz < 16) {
            sz = 16;
        } else if ((sz & sz - 1) != 0) {
            int curr;
            for (curr = 16; curr < sz; curr += curr) {
            }
            sz = curr;
        }
        this._tableInfo = new AtomicReference<TableInfo>(this.initTableInfo(sz));
    }

    private BytesToNameCanonicalizer(BytesToNameCanonicalizer parent, boolean intern, int seed, boolean failOnDoS, TableInfo state) {
        this._parent = parent;
        this._seed = seed;
        this._intern = intern;
        this._failOnDoS = failOnDoS;
        this._tableInfo = null;
        this._count = state.count;
        this._hashMask = state.mainHashMask;
        this._hash = state.mainHash;
        this._mainNames = state.mainNames;
        this._collList = state.collList;
        this._collCount = state.collCount;
        this._collEnd = state.collEnd;
        this._longestCollisionList = state.longestCollisionList;
        this._needRehash = false;
        this._hashShared = true;
        this._namesShared = true;
        this._collListShared = true;
    }

    private TableInfo initTableInfo(int sz) {
        return new TableInfo(0, sz - 1, new int[sz], new Name[sz], null, 0, 0, 0);
    }

    public static BytesToNameCanonicalizer createRoot() {
        long now = System.currentTimeMillis();
        int seed = (int)now + (int)(now >>> 32) | 1;
        return BytesToNameCanonicalizer.createRoot(seed);
    }

    protected static BytesToNameCanonicalizer createRoot(int seed) {
        return new BytesToNameCanonicalizer(64, true, seed, true);
    }

    public BytesToNameCanonicalizer makeChild(int flags) {
        return new BytesToNameCanonicalizer(this, JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(flags), this._seed, JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(flags), this._tableInfo.get());
    }

    @Deprecated
    public BytesToNameCanonicalizer makeChild(boolean canonicalize, boolean intern) {
        return new BytesToNameCanonicalizer(this, intern, this._seed, true, this._tableInfo.get());
    }

    public void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new TableInfo(this));
            this._hashShared = true;
            this._namesShared = true;
            this._collListShared = true;
        }
    }

    private void mergeChild(TableInfo childState) {
        int childCount = childState.count;
        TableInfo currState = this._tableInfo.get();
        if (childCount == currState.count) {
            return;
        }
        if (childCount > 6000) {
            childState = this.initTableInfo(64);
        }
        this._tableInfo.compareAndSet(currState, childState);
    }

    public int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().count;
        }
        return this._count;
    }

    public int bucketCount() {
        return this._hash.length;
    }

    public boolean maybeDirty() {
        return !this._hashShared;
    }

    public int hashSeed() {
        return this._seed;
    }

    public int collisionCount() {
        return this._collCount;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public static Name getEmptyName() {
        return Name1.getEmptyName();
    }

    public Name findName(int q1) {
        Bucket bucket;
        int hash = this.calcHash(q1);
        int ix = hash & this._hashMask;
        int val = this._hash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this._mainNames[ix];
            if (name == null) {
                return null;
            }
            if (name.equals(q1)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this._collList[--val]) != null) {
            return bucket.find(hash, q1, 0);
        }
        return null;
    }

    public Name findName(int q1, int q2) {
        Bucket bucket;
        int hash = q2 == 0 ? this.calcHash(q1) : this.calcHash(q1, q2);
        int ix = hash & this._hashMask;
        int val = this._hash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this._mainNames[ix];
            if (name == null) {
                return null;
            }
            if (name.equals(q1, q2)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this._collList[--val]) != null) {
            return bucket.find(hash, q1, q2);
        }
        return null;
    }

    public Name findName(int[] q, int qlen) {
        Bucket bucket;
        if (qlen < 3) {
            return this.findName(q[0], qlen < 2 ? 0 : q[1]);
        }
        int hash = this.calcHash(q, qlen);
        int ix = hash & this._hashMask;
        int val = this._hash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this._mainNames[ix];
            if (name == null || name.equals(q, qlen)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this._collList[--val]) != null) {
            return bucket.find(hash, q, qlen);
        }
        return null;
    }

    public Name addName(String name, int q1, int q2) {
        if (this._intern) {
            name = InternCache.instance.intern(name);
        }
        int hash = q2 == 0 ? this.calcHash(q1) : this.calcHash(q1, q2);
        Name symbol = BytesToNameCanonicalizer.constructName(hash, name, q1, q2);
        this._addSymbol(hash, symbol);
        return symbol;
    }

    public Name addName(String name, int[] q, int qlen) {
        if (this._intern) {
            name = InternCache.instance.intern(name);
        }
        int hash = qlen < 3 ? (qlen == 1 ? this.calcHash(q[0]) : this.calcHash(q[0], q[1])) : this.calcHash(q, qlen);
        Name symbol = BytesToNameCanonicalizer.constructName(hash, name, q, qlen);
        this._addSymbol(hash, symbol);
        return symbol;
    }

    public int calcHash(int q1) {
        int hash = q1 ^ this._seed;
        hash += hash >>> 15;
        hash ^= hash >>> 9;
        return hash;
    }

    public int calcHash(int q1, int q2) {
        int hash = q1;
        hash ^= hash >>> 15;
        hash += q2 * 33;
        hash ^= this._seed;
        hash += hash >>> 7;
        return hash;
    }

    public int calcHash(int[] q, int qlen) {
        if (qlen < 3) {
            throw new IllegalArgumentException();
        }
        int hash = q[0] ^ this._seed;
        hash += hash >>> 9;
        hash *= 33;
        hash += q[1];
        hash *= 65599;
        hash += hash >>> 15;
        hash ^= q[2];
        hash += hash >>> 17;
        for (int i = 3; i < qlen; ++i) {
            hash = hash * 31 ^ q[i];
            hash += hash >>> 3;
            hash ^= hash << 7;
        }
        hash += hash >>> 15;
        hash ^= hash << 9;
        return hash;
    }

    protected static int[] calcQuads(byte[] wordBytes) {
        int blen = wordBytes.length;
        int[] result = new int[(blen + 3) / 4];
        for (int i = 0; i < blen; ++i) {
            int x = wordBytes[i] & 0xFF;
            if (++i < blen) {
                x = x << 8 | wordBytes[i] & 0xFF;
                if (++i < blen) {
                    x = x << 8 | wordBytes[i] & 0xFF;
                    if (++i < blen) {
                        x = x << 8 | wordBytes[i] & 0xFF;
                    }
                }
            }
            result[i >> 2] = x;
        }
        return result;
    }

    private void _addSymbol(int hash, Name symbol) {
        if (this._hashShared) {
            this.unshareMain();
        }
        if (this._needRehash) {
            this.rehash();
        }
        ++this._count;
        int ix = hash & this._hashMask;
        if (this._mainNames[ix] == null) {
            this._hash[ix] = hash << 8;
            if (this._namesShared) {
                this.unshareNames();
            }
            this._mainNames[ix] = symbol;
        } else {
            if (this._collListShared) {
                this.unshareCollision();
            }
            ++this._collCount;
            int entryValue = this._hash[ix];
            int bucket = entryValue & 0xFF;
            if (bucket == 0) {
                if (this._collEnd <= 254) {
                    if ((bucket = this._collEnd++) >= this._collList.length) {
                        this.expandCollision();
                    }
                } else {
                    bucket = this.findBestBucket();
                }
                this._hash[ix] = entryValue & 0xFFFFFF00 | bucket + 1;
            } else {
                --bucket;
            }
            Bucket newB = new Bucket(symbol, this._collList[bucket]);
            int collLen = newB.length;
            if (collLen > 100) {
                this._handleSpillOverflow(bucket, newB);
            } else {
                this._collList[bucket] = newB;
                this._longestCollisionList = Math.max(newB.length, this._longestCollisionList);
            }
        }
        int hashSize = this._hash.length;
        if (this._count > hashSize >> 1) {
            int hashQuarter = hashSize >> 2;
            if (this._count > hashSize - hashQuarter) {
                this._needRehash = true;
            } else if (this._collCount >= hashQuarter) {
                this._needRehash = true;
            }
        }
    }

    private void _handleSpillOverflow(int bindex, Bucket newBucket) {
        if (this._overflows == null) {
            this._overflows = new BitSet();
            this._overflows.set(bindex);
        } else if (this._overflows.get(bindex)) {
            if (this._failOnDoS) {
                this.reportTooManyCollisions(100);
            }
            this._intern = false;
        } else {
            this._overflows.set(bindex);
        }
        this._collList[bindex] = null;
        this._count -= newBucket.length;
        this._longestCollisionList = -1;
    }

    private void rehash() {
        this._needRehash = false;
        this._namesShared = false;
        int[] oldMainHash = this._hash;
        int len = oldMainHash.length;
        int newLen = len + len;
        if (newLen > 65536) {
            this.nukeSymbols();
            return;
        }
        this._hash = new int[newLen];
        this._hashMask = newLen - 1;
        Name[] oldNames = this._mainNames;
        this._mainNames = new Name[newLen];
        int symbolsSeen = 0;
        for (int i = 0; i < len; ++i) {
            Name symbol = oldNames[i];
            if (symbol == null) continue;
            ++symbolsSeen;
            int hash = symbol.hashCode();
            int ix = hash & this._hashMask;
            this._mainNames[ix] = symbol;
            this._hash[ix] = hash << 8;
        }
        int oldEnd = this._collEnd;
        if (oldEnd == 0) {
            this._longestCollisionList = 0;
            return;
        }
        this._collCount = 0;
        this._collEnd = 0;
        this._collListShared = false;
        int maxColl = 0;
        Bucket[] oldBuckets = this._collList;
        this._collList = new Bucket[oldBuckets.length];
        for (int i = 0; i < oldEnd; ++i) {
            Bucket curr = oldBuckets[i];
            while (curr != null) {
                ++symbolsSeen;
                Name symbol = curr.name;
                int hash = symbol.hashCode();
                int ix = hash & this._hashMask;
                int val = this._hash[ix];
                if (this._mainNames[ix] == null) {
                    this._hash[ix] = hash << 8;
                    this._mainNames[ix] = symbol;
                } else {
                    Bucket newB;
                    ++this._collCount;
                    int bucket = val & 0xFF;
                    if (bucket == 0) {
                        if (this._collEnd <= 254) {
                            if ((bucket = this._collEnd++) >= this._collList.length) {
                                this.expandCollision();
                            }
                        } else {
                            bucket = this.findBestBucket();
                        }
                        this._hash[ix] = val & 0xFFFFFF00 | bucket + 1;
                    } else {
                        --bucket;
                    }
                    this._collList[bucket] = newB = new Bucket(symbol, this._collList[bucket]);
                    maxColl = Math.max(maxColl, newB.length);
                }
                curr = curr.next;
            }
        }
        this._longestCollisionList = maxColl;
        if (symbolsSeen != this._count) {
            throw new RuntimeException("Internal error: count after rehash " + symbolsSeen + "; should be " + this._count);
        }
    }

    private void nukeSymbols() {
        this._count = 0;
        this._longestCollisionList = 0;
        Arrays.fill(this._hash, 0);
        Arrays.fill(this._mainNames, null);
        Arrays.fill(this._collList, null);
        this._collCount = 0;
        this._collEnd = 0;
    }

    private int findBestBucket() {
        Bucket[] buckets = this._collList;
        int bestCount = Integer.MAX_VALUE;
        int bestIx = -1;
        int len = this._collEnd;
        for (int i = 0; i < len; ++i) {
            int count = buckets[i].length;
            if (count >= bestCount) continue;
            if (count == 1) {
                return i;
            }
            bestCount = count;
            bestIx = i;
        }
        return bestIx;
    }

    private void unshareMain() {
        int[] old = this._hash;
        this._hash = Arrays.copyOf(old, old.length);
        this._hashShared = false;
    }

    private void unshareCollision() {
        Bucket[] old = this._collList;
        this._collList = old == null ? new Bucket[32] : Arrays.copyOf(old, old.length);
        this._collListShared = false;
    }

    private void unshareNames() {
        Name[] old = this._mainNames;
        this._mainNames = Arrays.copyOf(old, old.length);
        this._namesShared = false;
    }

    private void expandCollision() {
        Bucket[] old = this._collList;
        this._collList = Arrays.copyOf(old, old.length * 2);
    }

    private static Name constructName(int hash, String name, int q1, int q2) {
        if (q2 == 0) {
            return new Name1(name, hash, q1);
        }
        return new Name2(name, hash, q1, q2);
    }

    private static Name constructName(int hash, String name, int[] quads, int qlen) {
        if (qlen < 4) {
            switch (qlen) {
                case 1: {
                    return new Name1(name, hash, quads[0]);
                }
                case 2: {
                    return new Name2(name, hash, quads[0], quads[1]);
                }
                case 3: {
                    return new Name3(name, hash, quads[0], quads[1], quads[2]);
                }
            }
        }
        return NameN.construct(name, hash, quads, qlen);
    }

    protected void reportTooManyCollisions(int maxLen) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._count + ") now exceeds maximum, " + maxLen + " -- suspect a DoS attack based on hash collisions");
    }

    private static final class Bucket {
        protected final Name name;
        protected final Bucket next;
        private final int hash;
        private final int length;

        Bucket(Name name, Bucket next) {
            this.name = name;
            this.next = next;
            this.length = next == null ? 1 : next.length + 1;
            this.hash = name.hashCode();
        }

        public Name find(int h, int firstQuad, int secondQuad) {
            if (this.hash == h && this.name.equals(firstQuad, secondQuad)) {
                return this.name;
            }
            Bucket curr = this.next;
            while (curr != null) {
                Name currName;
                if (curr.hash == h && (currName = curr.name).equals(firstQuad, secondQuad)) {
                    return currName;
                }
                curr = curr.next;
            }
            return null;
        }

        public Name find(int h, int[] quads, int qlen) {
            if (this.hash == h && this.name.equals(quads, qlen)) {
                return this.name;
            }
            Bucket curr = this.next;
            while (curr != null) {
                Name currName;
                if (curr.hash == h && (currName = curr.name).equals(quads, qlen)) {
                    return currName;
                }
                curr = curr.next;
            }
            return null;
        }
    }

    private static final class TableInfo {
        public final int count;
        public final int mainHashMask;
        public final int[] mainHash;
        public final Name[] mainNames;
        public final Bucket[] collList;
        public final int collCount;
        public final int collEnd;
        public final int longestCollisionList;

        public TableInfo(int count, int mainHashMask, int[] mainHash, Name[] mainNames, Bucket[] collList, int collCount, int collEnd, int longestCollisionList) {
            this.count = count;
            this.mainHashMask = mainHashMask;
            this.mainHash = mainHash;
            this.mainNames = mainNames;
            this.collList = collList;
            this.collCount = collCount;
            this.collEnd = collEnd;
            this.longestCollisionList = longestCollisionList;
        }

        public TableInfo(BytesToNameCanonicalizer src) {
            this.count = src._count;
            this.mainHashMask = src._hashMask;
            this.mainHash = src._hash;
            this.mainNames = src._mainNames;
            this.collList = src._collList;
            this.collCount = src._collCount;
            this.collEnd = src._collEnd;
            this.longestCollisionList = src._longestCollisionList;
        }
    }
}

