/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.lib;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.lib.Interns;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.util.Quantile;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.util.SampleQuantiles;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableQuantiles
extends MutableMetric {
    @VisibleForTesting
    public static final Quantile[] quantiles = new Quantile[]{new Quantile(0.5, 0.05), new Quantile(0.75, 0.025), new Quantile(0.9, 0.01), new Quantile(0.95, 0.005), new Quantile(0.99, 0.001)};
    private final MetricsInfo numInfo;
    private final MetricsInfo[] quantileInfos;
    private final int interval;
    private SampleQuantiles estimator;
    private long previousCount = 0L;
    @VisibleForTesting
    protected Map<Quantile, Long> previousSnapshot = null;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MutableQuantiles-%d").build());

    public MutableQuantiles(String name, String description, String sampleName, String valueName, int interval) {
        String ucName = StringUtils.capitalize(name);
        String usName = StringUtils.capitalize(sampleName);
        String uvName = StringUtils.capitalize(valueName);
        String desc = StringUtils.uncapitalize(description);
        String lsName = StringUtils.uncapitalize(sampleName);
        String lvName = StringUtils.uncapitalize(valueName);
        this.numInfo = Interns.info(ucName + "Num" + usName, String.format("Number of %s for %s with %ds interval", lsName, desc, interval));
        this.quantileInfos = new MetricsInfo[quantiles.length];
        String nameTemplate = ucName + "%dthPercentile" + uvName;
        String descTemplate = "%d percentile " + lvName + " with " + interval + " second interval for " + desc;
        for (int i = 0; i < quantiles.length; ++i) {
            int percentile = (int)(100.0 * MutableQuantiles.quantiles[i].quantile);
            this.quantileInfos[i] = Interns.info(String.format(nameTemplate, percentile), String.format(descTemplate, percentile));
        }
        this.estimator = new SampleQuantiles(quantiles);
        this.interval = interval;
        scheduler.scheduleAtFixedRate(new RolloverSample(this), interval, interval, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.numInfo, this.previousCount);
            for (int i = 0; i < quantiles.length; ++i) {
                long newValue = 0L;
                if (this.previousSnapshot != null) {
                    newValue = this.previousSnapshot.get(quantiles[i]);
                }
                builder.addGauge(this.quantileInfos[i], newValue);
            }
            if (this.changed()) {
                this.clearChanged();
            }
        }
    }

    public synchronized void add(long value) {
        this.estimator.insert(value);
    }

    public int getInterval() {
        return this.interval;
    }

    private static class RolloverSample
    implements Runnable {
        MutableQuantiles parent;

        public RolloverSample(MutableQuantiles parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MutableQuantiles mutableQuantiles = this.parent;
            synchronized (mutableQuantiles) {
                this.parent.previousCount = this.parent.estimator.getCount();
                this.parent.previousSnapshot = this.parent.estimator.snapshot();
                this.parent.estimator.clear();
            }
            this.parent.setChanged();
        }
    }
}

