/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ByteWritable
implements WritableComparable<ByteWritable> {
    private byte value;

    public ByteWritable() {
    }

    public ByteWritable(byte value) {
        this.set(value);
    }

    public void set(byte value) {
        this.value = value;
    }

    public byte get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteWritable)) {
            return false;
        }
        ByteWritable other = (ByteWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(ByteWritable o) {
        byte thisValue = this.value;
        byte thatValue = o.value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Byte.toString(this.value);
    }

    static {
        WritableComparator.define(ByteWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ByteWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            byte thisValue = b1[s1];
            byte thatValue = b2[s2];
            return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

