/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.ConfServlet;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http.AdminAuthorizedServlet;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http.FilterContainer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http.FilterInitializer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http.HtmlQuoting;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http.HttpRequestLog;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http.NoCacheFilter;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.jmx.JMXJsonServlet;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.log.LogLevel;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics.MetricsServlet;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.SecurityUtil;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.ssl.SslSelectChannelConnectorSecure;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.ReflectionUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.Shell;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.io.Buffer;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.Connector;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.Handler;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.HandlerContainer;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.MimeTypes;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.RequestLog;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.Server;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.SessionManager;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.handler.ContextHandler;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.handler.ContextHandlerCollection;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.handler.HandlerCollection;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.handler.RequestLogHandler;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.nio.SelectChannelConnector;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.AbstractSessionManager;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.Context;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.DefaultServlet;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.FilterHolder;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.FilterMapping;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.ServletHandler;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.ServletHolder;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.SessionHandler;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.webapp.WebAppContext;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.thread.QueuedThreadPool;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.thread.ThreadPool;
import org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.util.MultiException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class HttpServer2
implements FilterContainer {
    public static final Log LOG = LogFactory.getLog(HttpServer2.class);
    static final String FILTER_INITIALIZER_PROPERTY = "hadoop.http.filter.initializers";
    public static final String HTTP_MAX_THREADS = "hadoop.http.max.threads";
    public static final String CONF_CONTEXT_ATTRIBUTE = "hadoop.conf";
    public static final String ADMINS_ACL = "admins.acl";
    public static final String SPNEGO_FILTER = "SpnegoFilter";
    public static final String NO_CACHE_FILTER = "NoCacheFilter";
    public static final String BIND_ADDRESS = "bind.address";
    private final AccessControlList adminsAcl;
    protected final Server webServer;
    private final List<Connector> listeners = Lists.newArrayList();
    protected final WebAppContext webAppContext;
    protected final boolean findPort;
    protected final Map<Context, Boolean> defaultContexts = new HashMap<Context, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();
    static final String STATE_DESCRIPTION_ALIVE = " - alive";
    static final String STATE_DESCRIPTION_NOT_LIVE = " - not live";
    private final SignerSecretProvider secretProvider;
    private XFrameOption xFrameOption;
    private boolean xFrameOptionIsEnabled;
    private static final String X_FRAME_VALUE = "xFrameOption";
    private static final String X_FRAME_ENABLED = "X_FRAME_ENABLED";

    private HttpServer2(Builder b) throws IOException {
        String appDir = this.getWebAppsPath(b.name);
        this.webServer = new Server();
        this.adminsAcl = b.adminsAcl;
        this.webAppContext = HttpServer2.createWebAppContext(b.name, b.conf, this.adminsAcl, appDir);
        this.xFrameOptionIsEnabled = b.xFrameEnabled;
        this.xFrameOption = b.xFrameOption;
        try {
            this.secretProvider = HttpServer2.constructSecretProvider(b, (ServletContext)this.webAppContext.getServletContext());
            this.webAppContext.getServletContext().setAttribute("signer.secret.provider.object", (Object)this.secretProvider);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.findPort = b.findPort;
        this.initializeWebServer(b.name, b.hostName, b.conf, b.pathSpecs);
    }

    private void initializeWebServer(String name, String hostName, Configuration conf, String[] pathSpecs) throws IOException {
        Preconditions.checkNotNull(this.webAppContext);
        int maxThreads = conf.getInt(HTTP_MAX_THREADS, -1);
        QueuedThreadPool threadPool = maxThreads == -1 ? new QueuedThreadPool() : new QueuedThreadPool(maxThreads);
        threadPool.setDaemon(true);
        this.webServer.setThreadPool((ThreadPool)threadPool);
        SessionManager sm = this.webAppContext.getSessionHandler().getSessionManager();
        if (sm instanceof AbstractSessionManager) {
            AbstractSessionManager asm = (AbstractSessionManager)sm;
            asm.setHttpOnly(true);
            asm.setSecureCookies(true);
        }
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLog requestLog = HttpRequestLog.getRequestLog(name);
        if (requestLog != null) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog(requestLog);
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{contexts, requestLogHandler});
            this.webServer.setHandler((Handler)handlers);
        } else {
            this.webServer.setHandler((Handler)contexts);
        }
        String appDir = this.getWebAppsPath(name);
        this.webServer.addHandler((Handler)this.webAppContext);
        this.addDefaultApps(contexts, appDir, conf);
        HashMap<String, String> xFrameParams = new HashMap<String, String>();
        xFrameParams.put(X_FRAME_ENABLED, String.valueOf(this.xFrameOptionIsEnabled));
        xFrameParams.put(X_FRAME_VALUE, this.xFrameOption.toString());
        this.addGlobalFilter("safety", QuotingInputFilter.class.getName(), xFrameParams);
        FilterInitializer[] initializers = HttpServer2.getFilterInitializers(conf);
        if (initializers != null) {
            conf = new Configuration(conf);
            conf.set(BIND_ADDRESS, hostName);
            for (FilterInitializer c : initializers) {
                c.initFilter(this, conf);
            }
        }
        this.addDefaultServlets();
        if (pathSpecs != null) {
            for (String path : pathSpecs) {
                LOG.info("adding path spec: " + (String)path);
                this.addFilterPathMapping(path, (Context)this.webAppContext);
            }
        }
    }

    private void addListener(Connector connector) {
        this.listeners.add(connector);
    }

    private static WebAppContext createWebAppContext(String name, Configuration conf, AccessControlList adminsAcl, String appDir) {
        WebAppContext ctx = new WebAppContext();
        ctx.setDefaultsDescriptor(null);
        ServletHolder holder = new ServletHolder((Servlet)new DefaultServlet());
        ImmutableMap<String, String> params = ImmutableMap.builder().put("acceptRanges", "true").put("dirAllowed", "false").put("gzip", "true").put("useFileMappedBuffer", "true").build();
        holder.setInitParameters(params);
        ctx.setWelcomeFiles(new String[]{"index.html"});
        ctx.addServlet(holder, "/");
        ctx.setDisplayName(name);
        ctx.setContextPath("/");
        ctx.setWar(appDir + "/" + name);
        ctx.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        ctx.getServletContext().setAttribute(ADMINS_ACL, (Object)adminsAcl);
        HttpServer2.addNoCacheFilter(ctx);
        return ctx;
    }

    private static SignerSecretProvider constructSecretProvider(Builder b, ServletContext ctx) throws Exception {
        Configuration conf = b.conf;
        Properties config = HttpServer2.getFilterProperties(conf, b.authFilterConfigurationPrefix);
        return AuthenticationFilter.constructSecretProvider(ctx, config, b.disallowFallbackToRandomSignerSecretProvider);
    }

    private static Properties getFilterProperties(Configuration conf, String prefix) {
        Properties prop = new Properties();
        Map<String, String> filterConfig = AuthenticationFilterInitializer.getFilterConfigMap(conf, prefix);
        prop.putAll(filterConfig);
        return prop;
    }

    private static void addNoCacheFilter(WebAppContext ctxt) {
        HttpServer2.defineFilter((Context)ctxt, NO_CACHE_FILTER, NoCacheFilter.class.getName(), Collections.emptyMap(), new String[]{"/*"});
    }

    private static void configureChannelConnector(SelectChannelConnector c) {
        c.setLowResourceMaxIdleTime(10000);
        c.setAcceptQueueSize(128);
        c.setResolveNames(false);
        c.setUseDirectBuffers(false);
        if (Shell.WINDOWS) {
            c.setReuseAddress(false);
        }
        c.setHeaderBufferSize(65536);
    }

    @InterfaceAudience.Private
    public static Connector createDefaultChannelConnector() {
        SelectChannelConnectorWithSafeStartup ret = new SelectChannelConnectorWithSafeStartup();
        HttpServer2.configureChannelConnector(ret);
        return ret;
    }

    private static FilterInitializer[] getFilterInitializers(Configuration conf) {
        if (conf == null) {
            return null;
        }
        Class<?>[] classes = conf.getClasses(FILTER_INITIALIZER_PROPERTY, new Class[0]);
        if (classes == null) {
            return null;
        }
        FilterInitializer[] initializers = new FilterInitializer[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            initializers[i] = (FilterInitializer)ReflectionUtils.newInstance(classes[i], conf);
        }
        return initializers;
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir, Configuration conf) throws IOException {
        Map params;
        String logDir = System.getProperty("hadoop.log.dir");
        if (logDir != null) {
            Context logContext = new Context((HandlerContainer)parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(AdminAuthorizedServlet.class, "/*");
            if (conf.getBoolean("hadoop.jetty.logs.serve.aliases", true)) {
                params = logContext.getInitParams();
                params.put("org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.Default.aliases", "true");
            }
            logContext.setDisplayName("logs");
            SessionHandler handler = new SessionHandler();
            SessionManager sm = handler.getSessionManager();
            if (sm instanceof AbstractSessionManager) {
                AbstractSessionManager asm = (AbstractSessionManager)sm;
                asm.setHttpOnly(true);
                asm.setSecureCookies(true);
            }
            logContext.setSessionHandler(handler);
            this.setContextAttributes(logContext, conf);
            HttpServer2.addNoCacheFilter(this.webAppContext);
            this.defaultContexts.put(logContext, true);
        }
        Context staticContext = new Context((HandlerContainer)parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(DefaultServlet.class, "/*");
        staticContext.setDisplayName("static");
        params = staticContext.getInitParams();
        params.put("org.apache.flink.fs.openstackhadoop.shaded.org.mortbay.jetty.servlet.Default.dirAllowed", "false");
        SessionHandler handler = new SessionHandler();
        SessionManager sm = handler.getSessionManager();
        if (sm instanceof AbstractSessionManager) {
            AbstractSessionManager asm = (AbstractSessionManager)sm;
            asm.setHttpOnly(true);
            asm.setSecureCookies(true);
        }
        staticContext.setSessionHandler(handler);
        this.setContextAttributes(staticContext, conf);
        this.defaultContexts.put(staticContext, true);
    }

    private void setContextAttributes(Context context, Configuration conf) {
        context.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        context.getServletContext().setAttribute(ADMINS_ACL, (Object)this.adminsAcl);
    }

    protected void addDefaultServlets() {
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
        this.addServlet("metrics", "/metrics", MetricsServlet.class);
        this.addServlet("jmx", "/jmx", JMXJsonServlet.class);
        this.addServlet("conf", "/conf", ConfServlet.class);
    }

    public void addContext(Context ctxt, boolean isFiltered) {
        this.webServer.addHandler((Handler)ctxt);
        HttpServer2.addNoCacheFilter(this.webAppContext);
        this.defaultContexts.put(ctxt, isFiltered);
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public void addJerseyResourcePackage(String packageName, String pathSpec) {
        LOG.info("addJerseyResourcePackage: packageName=" + packageName + ", pathSpec=" + pathSpec);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", packageName);
        this.webAppContext.addServlet(sh, pathSpec);
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
        this.addFilterPathMapping(pathSpec, (Context)this.webAppContext);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuth) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
        if (requireAuth && UserGroupInformation.isSecurityEnabled()) {
            LOG.info("Adding Kerberos (SPNEGO) filter to " + name);
            ServletHandler handler = this.webAppContext.getServletHandler();
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(SPNEGO_FILTER);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    @Override
    public void addFilter(String name, String classname, Map<String, String> parameters) {
        FilterHolder filterHolder = HttpServer2.getFilterHolder(name, classname, parameters);
        String[] USER_FACING_URLS = new String[]{"*.html", "*.jsp"};
        FilterMapping fmap = HttpServer2.getFilterMapping(name, USER_FACING_URLS);
        HttpServer2.defineFilter((Context)this.webAppContext, filterHolder, fmap);
        LOG.info("Added filter " + name + " (class=" + classname + ") to context " + this.webAppContext.getDisplayName());
        String[] ALL_URLS = new String[]{"/*"};
        fmap = HttpServer2.getFilterMapping(name, ALL_URLS);
        for (Map.Entry<Context, Boolean> e : this.defaultContexts.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            Context ctx = e.getKey();
            HttpServer2.defineFilter(ctx, filterHolder, fmap);
            LOG.info("Added filter " + name + " (class=" + classname + ") to context " + ctx.getDisplayName());
        }
        this.filterNames.add(name);
    }

    @Override
    public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        String[] ALL_URLS = new String[]{"/*"};
        FilterHolder filterHolder = HttpServer2.getFilterHolder(name, classname, parameters);
        FilterMapping fmap = HttpServer2.getFilterMapping(name, ALL_URLS);
        HttpServer2.defineFilter((Context)this.webAppContext, filterHolder, fmap);
        for (Context ctx : this.defaultContexts.keySet()) {
            HttpServer2.defineFilter(ctx, filterHolder, fmap);
        }
        LOG.info("Added global filter '" + name + "' (class=" + classname + ")");
    }

    public static void defineFilter(Context ctx, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder filterHolder = HttpServer2.getFilterHolder(name, classname, parameters);
        FilterMapping fmap = HttpServer2.getFilterMapping(name, urls);
        HttpServer2.defineFilter(ctx, filterHolder, fmap);
    }

    private static void defineFilter(Context ctx, FilterHolder holder, FilterMapping fmap) {
        ServletHandler handler = ctx.getServletHandler();
        handler.addFilter(holder, fmap);
    }

    private static FilterMapping getFilterMapping(String name, String[] urls) {
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(15);
        fmap.setFilterName(name);
        return fmap;
    }

    private static FilterHolder getFilterHolder(String name, String classname, Map<String, String> parameters) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        holder.setInitParameters(parameters);
        return holder;
    }

    protected void addFilterPathMapping(String pathSpec, Context webAppCtx) {
        ServletHandler handler = webAppCtx.getServletHandler();
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    protected String getWebAppsPath(String appName) throws FileNotFoundException {
        URL url = this.getClass().getClassLoader().getResource("webapps/" + appName);
        if (url == null) {
            throw new FileNotFoundException("webapps/" + appName + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    @Deprecated
    public int getPort() {
        return this.webServer.getConnectors()[0].getLocalPort();
    }

    public InetSocketAddress getConnectorAddress(int index) {
        Preconditions.checkArgument(index >= 0);
        if (index > this.webServer.getConnectors().length) {
            return null;
        }
        Connector c = this.webServer.getConnectors()[index];
        if (c.getLocalPort() == -1) {
            return null;
        }
        return new InetSocketAddress(c.getHost(), c.getLocalPort());
    }

    public void setThreads(int min, int max) {
        QueuedThreadPool pool = (QueuedThreadPool)this.webServer.getThreadPool();
        pool.setMinThreads(min);
        pool.setMaxThreads(max);
    }

    private void initSpnego(Configuration conf, String hostName, String usernameConfKey, String keytabConfKey) throws IOException {
        String httpKeytab;
        HashMap<String, String> params = new HashMap<String, String>();
        String principalInConf = conf.get(usernameConfKey);
        if (principalInConf != null && !principalInConf.isEmpty()) {
            params.put("kerberos.principal", SecurityUtil.getServerPrincipal(principalInConf, hostName));
        }
        if ((httpKeytab = conf.get(keytabConfKey)) != null && !httpKeytab.isEmpty()) {
            params.put("kerberos.keytab", httpKeytab);
        }
        params.put("type", "kerberos");
        HttpServer2.defineFilter((Context)this.webAppContext, SPNEGO_FILTER, AuthenticationFilter.class.getName(), params, null);
    }

    public void start() throws IOException {
        try {
            Handler[] handlers;
            try {
                this.openListeners();
                this.webServer.start();
            }
            catch (IOException ex) {
                LOG.info("HttpServer.start() threw a non Bind IOException", ex);
                throw ex;
            }
            catch (MultiException ex) {
                LOG.info("HttpServer.start() threw a MultiException", ex);
                throw ex;
            }
            for (Handler handler : handlers = this.webServer.getHandlers()) {
                if (!handler.isFailed()) continue;
                throw new IOException("Problem in starting http server. Server handlers failed");
            }
            Throwable unavailableException = this.webAppContext.getUnavailableException();
            if (unavailableException != null) {
                this.webServer.stop();
                throw new IOException("Unable to initialize WebAppContext", unavailableException);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Interrupted while starting HTTP server").initCause(e);
        }
        catch (Exception e) {
            throw new IOException("Problem starting http server", e);
        }
    }

    private void loadListeners() {
        for (Connector c : this.listeners) {
            this.webServer.addConnector(c);
        }
    }

    void openListeners() throws Exception {
        block2: for (Connector listener : this.listeners) {
            if (listener.getLocalPort() != -1) continue;
            int port = listener.getPort();
            while (true) {
                try {
                    listener.close();
                    listener.open();
                    LOG.info("Jetty bound to port " + listener.getLocalPort());
                    continue block2;
                }
                catch (BindException ex) {
                    if (port == 0 || !this.findPort) {
                        BindException be = new BindException("Port in use: " + listener.getHost() + ":" + listener.getPort());
                        be.initCause(ex);
                        throw be;
                    }
                    listener.setPort(++port);
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
    }

    public void stop() throws Exception {
        MultiException exception = null;
        for (Connector c : this.listeners) {
            try {
                c.close();
            }
            catch (Exception e) {
                LOG.error("Error while stopping listener for webapp" + this.webAppContext.getDisplayName(), e);
                exception = this.addMultiException(exception, e);
            }
        }
        try {
            this.secretProvider.destroy();
            this.webAppContext.clearAttributes();
            this.webAppContext.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web app context for webapp " + this.webAppContext.getDisplayName(), e);
            exception = this.addMultiException(exception, e);
        }
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web server for webapp " + this.webAppContext.getDisplayName(), e);
            exception = this.addMultiException(exception, e);
        }
        if (exception != null) {
            exception.ifExceptionThrow();
        }
    }

    private MultiException addMultiException(MultiException exception, Exception e) {
        if (exception == null) {
            exception = new MultiException();
        }
        exception.add((Throwable)e);
        return exception;
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public boolean isAlive() {
        return this.webServer != null && this.webServer.isStarted();
    }

    public String toString() {
        Preconditions.checkState(!this.listeners.isEmpty());
        StringBuilder sb = new StringBuilder("HttpServer (").append(this.isAlive() ? STATE_DESCRIPTION_ALIVE : STATE_DESCRIPTION_NOT_LIVE).append("), listening at:");
        for (Connector l : this.listeners) {
            sb.append(l.getHost()).append(":").append(l.getPort()).append("/,");
        }
        return sb.toString();
    }

    public static boolean isStaticUserAndNoneAuthType(ServletContext servletContext, HttpServletRequest request) {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        String authType = request.getAuthType();
        String staticUser = conf.get("hadoop.http.staticuser.user", "dr.who");
        return authType == null && staticUser.equals(request.getRemoteUser());
    }

    public static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = HttpServer2.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    public static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            response.sendError(403, "Unauthenticated users are not authorized to access this page.");
            return false;
        }
        if (servletContext.getAttribute(ADMINS_ACL) != null && !HttpServer2.userHasAdministratorAccess(servletContext, remoteUser)) {
            response.sendError(403, "User " + remoteUser + " is unauthorized to access this page.");
            return false;
        }
        return true;
    }

    public static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser(remoteUser);
        return adminsAcl != null && adminsAcl.isUserAllowed(remoteUserUGI);
    }

    public static enum XFrameOption {
        DENY("DENY"),
        SAMEORIGIN("SAMEORIGIN"),
        ALLOWFROM("ALLOW-FROM");

        private final String name;

        private XFrameOption(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private static XFrameOption getEnum(String value) {
            Preconditions.checkState(value != null && !value.isEmpty());
            for (XFrameOption xoption : XFrameOption.values()) {
                if (!value.equals(xoption.toString())) continue;
                return xoption;
            }
            throw new IllegalArgumentException("Unexpected value in xFrameOption.");
        }
    }

    public static class QuotingInputFilter
    implements Filter {
        private FilterConfig config;

        public void init(FilterConfig config) throws ServletException {
            this.config = config;
        }

        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestQuoter quoted = new RequestQuoter((HttpServletRequest)request);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String mime = this.inferMimeType(request);
            if (mime == null) {
                httpResponse.setContentType("text/plain; charset=utf-8");
            } else if (mime.startsWith("text/html")) {
                httpResponse.setContentType("text/html; charset=utf-8");
            } else if (mime.startsWith("application/xml")) {
                httpResponse.setContentType("text/xml; charset=utf-8");
            }
            if (Boolean.valueOf(this.config.getInitParameter(HttpServer2.X_FRAME_ENABLED)).booleanValue()) {
                httpResponse.addHeader("X-FRAME-OPTIONS", this.config.getInitParameter(HttpServer2.X_FRAME_VALUE));
            }
            chain.doFilter((ServletRequest)quoted, (ServletResponse)httpResponse);
        }

        private String inferMimeType(ServletRequest request) {
            String path = ((HttpServletRequest)request).getRequestURI();
            ContextHandler.SContext sContext = (ContextHandler.SContext)this.config.getServletContext();
            MimeTypes mimes = sContext.getContextHandler().getMimeTypes();
            Buffer mimeBuffer = mimes.getMimeByExtension(path);
            return mimeBuffer == null ? null : mimeBuffer.toString();
        }

        public static class RequestQuoter
        extends HttpServletRequestWrapper {
            private final HttpServletRequest rawRequest;

            public RequestQuoter(HttpServletRequest rawRequest) {
                super(rawRequest);
                this.rawRequest = rawRequest;
            }

            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    private Enumeration<String> rawIterator;
                    {
                        this.rawIterator = RequestQuoter.this.rawRequest.getParameterNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.rawIterator.hasMoreElements();
                    }

                    @Override
                    public String nextElement() {
                        return HtmlQuoting.quoteHtmlChars(this.rawIterator.nextElement());
                    }
                };
            }

            public String getParameter(String name) {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getParameter(HtmlQuoting.unquoteHtmlChars(name)));
            }

            public String[] getParameterValues(String name) {
                String unquoteName = HtmlQuoting.unquoteHtmlChars(name);
                String[] unquoteValue = this.rawRequest.getParameterValues(unquoteName);
                if (unquoteValue == null) {
                    return null;
                }
                String[] result = new String[unquoteValue.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = HtmlQuoting.quoteHtmlChars(unquoteValue[i]);
                }
                return result;
            }

            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                Map raw = this.rawRequest.getParameterMap();
                for (Map.Entry item : raw.entrySet()) {
                    String[] rawValue = (String[])item.getValue();
                    String[] cookedValue = new String[rawValue.length];
                    for (int i = 0; i < rawValue.length; ++i) {
                        cookedValue[i] = HtmlQuoting.quoteHtmlChars(rawValue[i]);
                    }
                    result.put(HtmlQuoting.quoteHtmlChars((String)item.getKey()), cookedValue);
                }
                return result;
            }

            public StringBuffer getRequestURL() {
                String url = this.rawRequest.getRequestURL().toString();
                return new StringBuffer(HtmlQuoting.quoteHtmlChars(url));
            }

            public String getServerName() {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getServerName());
            }
        }
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ServletContext servletContext = this.getServletContext();
            if (!HttpServer2.isStaticUserAndNoneAuthType(servletContext, request) && !HttpServer2.isInstrumentationAccessAllowed(servletContext, request, response)) {
                return;
            }
            response.setContentType("text/plain; charset=UTF-8");
            try (PrintStream out = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");){
                ReflectionUtils.printThreadInfo(out, "");
            }
            ReflectionUtils.logThreadInfo(LOG, "jsp requested", 1L);
        }
    }

    private static class SelectChannelConnectorWithSafeStartup
    extends SelectChannelConnector {
        public boolean isRunning() {
            if (super.isRunning()) {
                return true;
            }
            LOG.warn("HttpServer Acceptor: isRunning is false. Rechecking.");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            boolean runState = super.isRunning();
            LOG.warn("HttpServer Acceptor: isRunning is " + runState);
            return runState;
        }
    }

    public static class Builder {
        private ArrayList<URI> endpoints = Lists.newArrayList();
        private String name;
        private Configuration conf;
        private String[] pathSpecs;
        private AccessControlList adminsAcl;
        private boolean securityEnabled = false;
        private String usernameConfKey;
        private String keytabConfKey;
        private boolean needsClientAuth;
        private String trustStore;
        private String trustStorePassword;
        private String trustStoreType;
        private String keyStore;
        private String keyStorePassword;
        private String keyStoreType;
        private String keyPassword;
        private boolean findPort;
        private String hostName;
        private boolean disallowFallbackToRandomSignerSecretProvider;
        private String authFilterConfigurationPrefix = "hadoop.http.authentication.";
        private String excludeCiphers;
        private boolean xFrameEnabled;
        private XFrameOption xFrameOption = XFrameOption.SAMEORIGIN;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addEndpoint(URI endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder trustStore(String location, String password, String type) {
            this.trustStore = location;
            this.trustStorePassword = password;
            this.trustStoreType = type;
            return this;
        }

        public Builder keyStore(String location, String password, String type) {
            this.keyStore = location;
            this.keyStorePassword = password;
            this.keyStoreType = type;
            return this;
        }

        public Builder keyPassword(String password) {
            this.keyPassword = password;
            return this;
        }

        public Builder needsClientAuth(boolean value) {
            this.needsClientAuth = value;
            return this;
        }

        public Builder setFindPort(boolean findPort) {
            this.findPort = findPort;
            return this;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setPathSpec(String[] pathSpec) {
            this.pathSpecs = pathSpec;
            return this;
        }

        public Builder setACL(AccessControlList acl) {
            this.adminsAcl = acl;
            return this;
        }

        public Builder setSecurityEnabled(boolean securityEnabled) {
            this.securityEnabled = securityEnabled;
            return this;
        }

        public Builder setUsernameConfKey(String usernameConfKey) {
            this.usernameConfKey = usernameConfKey;
            return this;
        }

        public Builder setKeytabConfKey(String keytabConfKey) {
            this.keytabConfKey = keytabConfKey;
            return this;
        }

        public Builder disallowFallbackToRandomSingerSecretProvider(boolean value) {
            this.disallowFallbackToRandomSignerSecretProvider = value;
            return this;
        }

        public Builder authFilterConfigurationPrefix(String value) {
            this.authFilterConfigurationPrefix = value;
            return this;
        }

        public Builder excludeCiphers(String pExcludeCiphers) {
            this.excludeCiphers = pExcludeCiphers;
            return this;
        }

        public Builder configureXFrame(boolean xFrameEnabled) {
            this.xFrameEnabled = xFrameEnabled;
            return this;
        }

        public Builder setXFrameOption(String option) {
            this.xFrameOption = XFrameOption.getEnum(option);
            return this;
        }

        public HttpServer2 build() throws IOException {
            Preconditions.checkNotNull(this.name, "name is not set");
            Preconditions.checkState(!this.endpoints.isEmpty(), "No endpoints specified");
            if (this.hostName == null) {
                this.hostName = this.endpoints.get(0).getHost();
            }
            if (this.conf == null) {
                this.conf = new Configuration();
            }
            HttpServer2 server = new HttpServer2(this);
            if (this.securityEnabled) {
                server.initSpnego(this.conf, this.hostName, this.usernameConfKey, this.keytabConfKey);
            }
            for (URI ep : this.endpoints) {
                Connector listener;
                String scheme = ep.getScheme();
                if ("http".equals(scheme)) {
                    listener = HttpServer2.createDefaultChannelConnector();
                } else if ("https".equals(scheme)) {
                    listener = this.createHttpsChannelConnector();
                } else {
                    throw new HadoopIllegalArgumentException("unknown scheme for endpoint:" + ep);
                }
                listener.setHost(ep.getHost());
                listener.setPort(ep.getPort() == -1 ? 0 : ep.getPort());
                server.addListener(listener);
            }
            server.loadListeners();
            return server;
        }

        private Connector createHttpsChannelConnector() {
            SslSelectChannelConnectorSecure c = new SslSelectChannelConnectorSecure();
            HttpServer2.configureChannelConnector(c);
            c.setNeedClientAuth(this.needsClientAuth);
            c.setKeyPassword(this.keyPassword);
            if (this.keyStore != null) {
                c.setKeystore(this.keyStore);
                c.setKeystoreType(this.keyStoreType);
                c.setPassword(this.keyStorePassword);
            }
            if (this.trustStore != null) {
                c.setTruststore(this.trustStore);
                c.setTruststoreType(this.trustStoreType);
                c.setTrustPassword(this.trustStorePassword);
            }
            if (null != this.excludeCiphers && !this.excludeCiphers.isEmpty()) {
                c.setExcludeCipherSuites(this.excludeCiphers.split(","));
                LOG.info("Excluded Cipher List:" + this.excludeCiphers);
            }
            return c;
        }
    }
}

