/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;

abstract class ImageVisitor {
    ImageVisitor() {
    }

    abstract void start() throws IOException;

    abstract void finish() throws IOException;

    abstract void finishAbnormally() throws IOException;

    abstract void visit(ImageElement var1, String var2) throws IOException;

    void visit(ImageElement element, int value) throws IOException {
        this.visit(element, Integer.toString(value));
    }

    void visit(ImageElement element, long value) throws IOException {
        this.visit(element, Long.toString(value));
    }

    abstract void visitEnclosingElement(ImageElement var1) throws IOException;

    abstract void visitEnclosingElement(ImageElement var1, ImageElement var2, String var3) throws IOException;

    void visitEnclosingElement(ImageElement element, ImageElement key, int value) throws IOException {
        this.visitEnclosingElement(element, key, Integer.toString(value));
    }

    void visitEnclosingElement(ImageElement element, ImageElement key, long value) throws IOException {
        this.visitEnclosingElement(element, key, Long.toString(value));
    }

    abstract void leaveEnclosingElement() throws IOException;

    public static enum ImageElement {
        FS_IMAGE,
        IMAGE_VERSION,
        NAMESPACE_ID,
        IS_COMPRESSED,
        COMPRESS_CODEC,
        LAYOUT_VERSION,
        NUM_INODES,
        GENERATION_STAMP,
        GENERATION_STAMP_V2,
        GENERATION_STAMP_V1_LIMIT,
        LAST_ALLOCATED_BLOCK_ID,
        INODES,
        INODE,
        INODE_PATH,
        REPLICATION,
        MODIFICATION_TIME,
        ACCESS_TIME,
        BLOCK_SIZE,
        NUM_BLOCKS,
        BLOCKS,
        BLOCK,
        BLOCK_ID,
        NUM_BYTES,
        NS_QUOTA,
        DS_QUOTA,
        PERMISSIONS,
        SYMLINK,
        NUM_INODES_UNDER_CONSTRUCTION,
        INODES_UNDER_CONSTRUCTION,
        INODE_UNDER_CONSTRUCTION,
        PREFERRED_BLOCK_SIZE,
        CLIENT_NAME,
        CLIENT_MACHINE,
        USER_NAME,
        GROUP_NAME,
        PERMISSION_STRING,
        CURRENT_DELEGATION_KEY_ID,
        NUM_DELEGATION_KEYS,
        DELEGATION_KEYS,
        DELEGATION_KEY,
        DELEGATION_TOKEN_SEQUENCE_NUMBER,
        NUM_DELEGATION_TOKENS,
        DELEGATION_TOKENS,
        DELEGATION_TOKEN_IDENTIFIER,
        DELEGATION_TOKEN_IDENTIFIER_KIND,
        DELEGATION_TOKEN_IDENTIFIER_SEQNO,
        DELEGATION_TOKEN_IDENTIFIER_OWNER,
        DELEGATION_TOKEN_IDENTIFIER_RENEWER,
        DELEGATION_TOKEN_IDENTIFIER_REALUSER,
        DELEGATION_TOKEN_IDENTIFIER_ISSUE_DATE,
        DELEGATION_TOKEN_IDENTIFIER_MAX_DATE,
        DELEGATION_TOKEN_IDENTIFIER_EXPIRY_TIME,
        DELEGATION_TOKEN_IDENTIFIER_MASTER_KEY_ID,
        TRANSACTION_ID,
        LAST_INODE_ID,
        INODE_ID,
        SNAPSHOT_COUNTER,
        NUM_SNAPSHOTS_TOTAL,
        NUM_SNAPSHOTS,
        SNAPSHOTS,
        SNAPSHOT,
        SNAPSHOT_ID,
        SNAPSHOT_ROOT,
        SNAPSHOT_QUOTA,
        NUM_SNAPSHOT_DIR_DIFF,
        SNAPSHOT_DIR_DIFFS,
        SNAPSHOT_DIR_DIFF,
        SNAPSHOT_DIFF_SNAPSHOTID,
        SNAPSHOT_DIR_DIFF_CHILDREN_SIZE,
        SNAPSHOT_INODE_FILE_ATTRIBUTES,
        SNAPSHOT_INODE_DIRECTORY_ATTRIBUTES,
        SNAPSHOT_DIR_DIFF_CREATEDLIST,
        SNAPSHOT_DIR_DIFF_CREATEDLIST_SIZE,
        SNAPSHOT_DIR_DIFF_CREATED_INODE,
        SNAPSHOT_DIR_DIFF_DELETEDLIST,
        SNAPSHOT_DIR_DIFF_DELETEDLIST_SIZE,
        SNAPSHOT_DIR_DIFF_DELETED_INODE,
        IS_SNAPSHOTTABLE_DIR,
        IS_WITHSNAPSHOT_DIR,
        SNAPSHOT_FILE_DIFFS,
        SNAPSHOT_FILE_DIFF,
        NUM_SNAPSHOT_FILE_DIFF,
        SNAPSHOT_FILE_SIZE,
        SNAPSHOT_DST_SNAPSHOT_ID,
        SNAPSHOT_LAST_SNAPSHOT_ID,
        SNAPSHOT_REF_INODE_ID,
        SNAPSHOT_REF_INODE,
        CACHE_NEXT_ENTRY_ID,
        CACHE_NUM_POOLS,
        CACHE_POOL_NAME,
        CACHE_POOL_OWNER_NAME,
        CACHE_POOL_GROUP_NAME,
        CACHE_POOL_PERMISSION_STRING,
        CACHE_POOL_WEIGHT,
        CACHE_NUM_ENTRIES,
        CACHE_ENTRY_PATH,
        CACHE_ENTRY_REPLICATION,
        CACHE_ENTRY_POOL_NAME;

    }
}

