/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.metrics;

import java.io.IOException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.MetricsTag;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.lib.Interns;

public class DataNodeMetricHelper {
    public static void getMetrics(MetricsCollector collector, FSDatasetMBean beanClass, String context) throws IOException {
        if (beanClass == null) {
            throw new IOException("beanClass cannot be null");
        }
        String className = beanClass.getClass().getName();
        collector.addRecord(className).setContext(context).addGauge(Interns.info("Capacity", "Total storage capacity"), beanClass.getCapacity()).addGauge(Interns.info("DfsUsed", "Total bytes used by dfs datanode"), beanClass.getDfsUsed()).addGauge(Interns.info("Remaining", "Total bytes of free storage"), beanClass.getRemaining()).add(new MetricsTag(Interns.info("StorageInfo", "Storage ID"), beanClass.getStorageInfo())).addGauge(Interns.info("NumFailedVolumes", "Number of failed Volumes in the data Node"), beanClass.getNumFailedVolumes()).addGauge(Interns.info("LastVolumeFailureDate", "Last Volume failure in milliseconds from epoch"), beanClass.getLastVolumeFailureDate()).addGauge(Interns.info("EstimatedCapacityLostTotal", "Total capacity lost due to volume failure"), beanClass.getEstimatedCapacityLostTotal()).addGauge(Interns.info("CacheUsed", "Datanode cache used in bytes"), beanClass.getCacheUsed()).addGauge(Interns.info("CacheCapacity", "Datanode cache capacity"), beanClass.getCacheCapacity()).addGauge(Interns.info("NumBlocksCached", "Datanode number of blocks cached"), beanClass.getNumBlocksCached()).addGauge(Interns.info("NumBlocksFailedToCache", "Datanode number of blocks failed to cache"), beanClass.getNumBlocksFailedToCache()).addGauge(Interns.info("NumBlocksFailedToUnCache", "Datanode number of blocks failed in cache eviction"), beanClass.getNumBlocksFailedToUncache());
    }
}

