/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.AutoCloseableLock;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.LightWeightResizableGSet;

class ReplicaMap {
    private final AutoCloseableLock lock;
    private final Map<String, LightWeightResizableGSet<Block, ReplicaInfo>> map = new HashMap<String, LightWeightResizableGSet<Block, ReplicaInfo>>();

    ReplicaMap(AutoCloseableLock lock) {
        if (lock == null) {
            throw new HadoopIllegalArgumentException("Lock to synchronize on cannot be null");
        }
        this.lock = lock;
    }

    String[] getBlockPoolList() {
        try (AutoCloseableLock l = this.lock.acquire();){
            String[] stringArray = this.map.keySet().toArray(new String[this.map.keySet().size()]);
            return stringArray;
        }
    }

    private void checkBlockPool(String bpid) {
        if (bpid == null) {
            throw new IllegalArgumentException("Block Pool Id is null");
        }
    }

    private void checkBlock(Block b) {
        if (b == null) {
            throw new IllegalArgumentException("Block is null");
        }
    }

    ReplicaInfo get(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        ReplicaInfo replicaInfo = this.get(bpid, block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    ReplicaInfo get(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            ReplicaInfo replicaInfo = m != null ? (ReplicaInfo)m.get(new Block(blockId)) : null;
            return replicaInfo;
        }
    }

    ReplicaInfo add(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseableLock l = this.lock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m == null) {
                m = new LightWeightResizableGSet();
                this.map.put(bpid, m);
            }
            ReplicaInfo replicaInfo2 = m.put(replicaInfo);
            return replicaInfo2;
        }
    }

    void addAll(ReplicaMap other) {
        this.map.putAll(other.map);
    }

    ReplicaInfo remove(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        try (AutoCloseableLock l = this.lock.acquire();){
            ReplicaInfo replicaInfo;
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m != null && (replicaInfo = (ReplicaInfo)m.get(block)) != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
                ReplicaInfo replicaInfo2 = (ReplicaInfo)m.remove(block);
                return replicaInfo2;
            }
        }
        return null;
    }

    ReplicaInfo remove(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m != null) {
                ReplicaInfo replicaInfo = (ReplicaInfo)m.remove(new Block(blockId));
                return replicaInfo;
            }
        }
        return null;
    }

    int size(String bpid) {
        LightWeightResizableGSet<Block, ReplicaInfo> m = null;
        try (AutoCloseableLock l = this.lock.acquire();){
            m = this.map.get(bpid);
            int n = m != null ? m.size() : 0;
            return n;
        }
    }

    Collection<ReplicaInfo> replicas(String bpid) {
        LightWeightResizableGSet<Block, ReplicaInfo> m = null;
        m = this.map.get(bpid);
        return m != null ? m.values() : null;
    }

    void initBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m == null) {
                m = new LightWeightResizableGSet();
                this.map.put(bpid, m);
            }
        }
    }

    void cleanUpBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            this.map.remove(bpid);
        }
    }

    AutoCloseableLock getLock() {
        return this.lock;
    }
}

