/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.FileUtil;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.HardLink;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.Daemon;

@InterfaceAudience.Private
public class BlockPoolSliceStorage
extends Storage {
    static final String TRASH_ROOT_DIR = "trash";
    static final String ROLLING_UPGRADE_MARKER_FILE = "RollingUpgradeInProgress";
    private static final String BLOCK_POOL_ID_PATTERN_BASE = Pattern.quote(File.separator) + "BP-\\d+-\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}-\\d+" + Pattern.quote(File.separator);
    private static final Pattern BLOCK_POOL_PATH_PATTERN = Pattern.compile("^(.*)(" + BLOCK_POOL_ID_PATTERN_BASE + ")(.*)$");
    private static final Pattern BLOCK_POOL_CURRENT_PATH_PATTERN = Pattern.compile("^(.*)(" + BLOCK_POOL_ID_PATTERN_BASE + ")(" + "current" + ")(.*)$");
    private static final Pattern BLOCK_POOL_TRASH_PATH_PATTERN = Pattern.compile("^(.*)(" + BLOCK_POOL_ID_PATTERN_BASE + ")(" + "trash" + ")(.*)$");
    private String blockpoolID = "";
    private Daemon trashCleaner;
    private static Set<String> storagesWithRollingUpgradeMarker;
    private static Set<String> storagesWithoutRollingUpgradeMarker;

    public BlockPoolSliceStorage(StorageInfo storageInfo, String bpid) {
        super(storageInfo);
        this.blockpoolID = bpid;
    }

    BlockPoolSliceStorage(int namespaceID, String bpID, long cTime, String clusterId) {
        super(HdfsServerConstants.NodeType.DATA_NODE);
        this.namespaceID = namespaceID;
        this.blockpoolID = bpID;
        this.cTime = cTime;
        this.clusterID = clusterId;
        storagesWithRollingUpgradeMarker = Collections.newSetFromMap(new ConcurrentHashMap());
        storagesWithoutRollingUpgradeMarker = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    private BlockPoolSliceStorage() {
        super(HdfsServerConstants.NodeType.DATA_NODE);
        storagesWithRollingUpgradeMarker = Collections.newSetFromMap(new ConcurrentHashMap());
        storagesWithoutRollingUpgradeMarker = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public void addStorageDir(Storage.StorageDirectory sd) {
        super.addStorageDir(sd);
    }

    private Storage.StorageDirectory loadStorageDirectory(NamespaceInfo nsInfo, File dataDir, HdfsServerConstants.StartupOption startOpt, List<Callable<Storage.StorageDirectory>> callables, Configuration conf) throws IOException {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(dataDir, null, true);
        try {
            Storage.StorageState curState = sd.analyzeStorage(startOpt, this);
            switch (curState) {
                case NORMAL: {
                    break;
                }
                case NON_EXISTENT: {
                    LOG.info("Block pool storage directory " + dataDir + " does not exist");
                    throw new IOException("Storage directory " + dataDir + " does not exist");
                }
                case NOT_FORMATTED: {
                    LOG.info("Block pool storage directory " + dataDir + " is not formatted for " + nsInfo.getBlockPoolID() + ". Formatting ...");
                    this.format(sd, nsInfo);
                    break;
                }
                default: {
                    sd.doRecover(curState);
                }
            }
            if (!this.doTransition(sd, nsInfo, startOpt, callables, conf)) {
                if (this.getCTime() != nsInfo.getCTime()) {
                    throw new IOException("Datanode CTime (=" + this.getCTime() + ") is not equal to namenode CTime (=" + nsInfo.getCTime() + ")");
                }
                this.setServiceLayoutVersion(this.getServiceLayoutVersion());
                this.writeProperties(sd);
            }
            return sd;
        }
        catch (IOException ioe) {
            sd.unlock();
            throw ioe;
        }
    }

    List<Storage.StorageDirectory> loadBpStorageDirectories(NamespaceInfo nsInfo, Collection<File> dataDirs, HdfsServerConstants.StartupOption startOpt, List<Callable<Storage.StorageDirectory>> callables, Configuration conf) throws IOException {
        ArrayList<Storage.StorageDirectory> succeedDirs = Lists.newArrayList();
        try {
            for (File dataDir : dataDirs) {
                if (this.containsStorageDir(dataDir)) {
                    throw new IOException("BlockPoolSliceStorage.recoverTransitionRead: attempt to load an used block storage: " + dataDir);
                }
                Storage.StorageDirectory sd = this.loadStorageDirectory(nsInfo, dataDir, startOpt, callables, conf);
                succeedDirs.add(sd);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to analyze storage directories for block pool " + nsInfo.getBlockPoolID(), e);
            throw e;
        }
        return succeedDirs;
    }

    List<Storage.StorageDirectory> recoverTransitionRead(NamespaceInfo nsInfo, Collection<File> dataDirs, HdfsServerConstants.StartupOption startOpt, List<Callable<Storage.StorageDirectory>> callables, Configuration conf) throws IOException {
        LOG.info("Analyzing storage directories for bpid " + nsInfo.getBlockPoolID());
        List<Storage.StorageDirectory> loaded = this.loadBpStorageDirectories(nsInfo, dataDirs, startOpt, callables, conf);
        for (Storage.StorageDirectory sd : loaded) {
            this.addStorageDir(sd);
        }
        return loaded;
    }

    void format(File dnCurDir, NamespaceInfo nsInfo) throws IOException {
        File curBpDir = BlockPoolSliceStorage.getBpRoot(nsInfo.getBlockPoolID(), dnCurDir);
        Storage.StorageDirectory bpSdir = new Storage.StorageDirectory(curBpDir);
        this.format(bpSdir, nsInfo);
    }

    private void format(Storage.StorageDirectory bpSdir, NamespaceInfo nsInfo) throws IOException {
        LOG.info("Formatting block pool " + this.blockpoolID + " directory " + bpSdir.getCurrentDir());
        bpSdir.clearDirectory();
        this.layoutVersion = HdfsServerConstants.DATANODE_LAYOUT_VERSION;
        this.cTime = nsInfo.getCTime();
        this.namespaceID = nsInfo.getNamespaceID();
        this.blockpoolID = nsInfo.getBlockPoolID();
        this.writeProperties(bpSdir);
    }

    void remove(File absPathToRemove) {
        Preconditions.checkArgument(absPathToRemove.isAbsolute());
        LOG.info("Removing block level storage: " + absPathToRemove);
        Iterator it = this.storageDirs.iterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = (Storage.StorageDirectory)it.next();
            if (!sd.getRoot().getAbsoluteFile().equals(absPathToRemove)) continue;
            it.remove();
            break;
        }
    }

    @Override
    protected void setPropertiesFromFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        props.setProperty("blockpoolID", this.blockpoolID);
        props.setProperty("cTime", String.valueOf(this.cTime));
    }

    private void setBlockPoolID(File storage, String bpid) throws InconsistentFSStateException {
        if (bpid == null || bpid.equals("")) {
            throw new InconsistentFSStateException(storage, "file VERSION is invalid.");
        }
        if (!this.blockpoolID.equals("") && !this.blockpoolID.equals(bpid)) {
            throw new InconsistentFSStateException(storage, "Unexpected blockpoolID " + bpid + ". Expected " + this.blockpoolID);
        }
        this.blockpoolID = bpid;
    }

    @Override
    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        this.setLayoutVersion(props, sd);
        this.setNamespaceID(props, sd);
        this.setcTime(props, sd);
        String sbpid = props.getProperty("blockpoolID");
        this.setBlockPoolID(sd.getRoot(), sbpid);
    }

    private boolean doTransition(Storage.StorageDirectory sd, NamespaceInfo nsInfo, HdfsServerConstants.StartupOption startOpt, List<Callable<Storage.StorageDirectory>> callables, Configuration conf) throws IOException {
        int restored;
        if (startOpt == HdfsServerConstants.StartupOption.ROLLBACK && sd.getPreviousDir().exists()) {
            Preconditions.checkState(!this.getTrashRootDir(sd).exists(), sd.getPreviousDir() + " and " + this.getTrashRootDir(sd) + " should not " + " both be present.");
            this.doRollback(sd, nsInfo);
        } else if (startOpt == HdfsServerConstants.StartupOption.ROLLBACK && !sd.getPreviousDir().exists()) {
            restored = this.restoreBlockFilesFromTrash(this.getTrashRootDir(sd));
            LOG.info("Restored " + restored + " block files from trash.");
        }
        this.readProperties(sd);
        BlockPoolSliceStorage.checkVersionUpgradable(this.layoutVersion);
        assert (this.layoutVersion >= HdfsServerConstants.DATANODE_LAYOUT_VERSION) : "Future version is not allowed";
        if (this.getNamespaceID() != nsInfo.getNamespaceID()) {
            throw new IOException("Incompatible namespaceIDs in " + sd.getRoot().getCanonicalPath() + ": namenode namespaceID = " + nsInfo.getNamespaceID() + "; datanode namespaceID = " + this.getNamespaceID());
        }
        if (!this.blockpoolID.equals(nsInfo.getBlockPoolID())) {
            throw new IOException("Incompatible blockpoolIDs in " + sd.getRoot().getCanonicalPath() + ": namenode blockpoolID = " + nsInfo.getBlockPoolID() + "; datanode blockpoolID = " + this.blockpoolID);
        }
        if (this.layoutVersion == HdfsServerConstants.DATANODE_LAYOUT_VERSION && this.cTime == nsInfo.getCTime()) {
            return false;
        }
        if (this.layoutVersion > HdfsServerConstants.DATANODE_LAYOUT_VERSION) {
            restored = this.restoreBlockFilesFromTrash(this.getTrashRootDir(sd));
            LOG.info("Restored " + restored + " block files from trash " + "before the layout upgrade. These blocks will be moved to " + "the previous directory during the upgrade");
        }
        if (this.layoutVersion > HdfsServerConstants.DATANODE_LAYOUT_VERSION || this.cTime < nsInfo.getCTime()) {
            this.doUpgrade(sd, nsInfo, callables, conf);
            return true;
        }
        throw new IOException("Datanode state: LV = " + this.getLayoutVersion() + " CTime = " + this.getCTime() + " is newer than the namespace state: LV = " + nsInfo.getLayoutVersion() + " CTime = " + nsInfo.getCTime());
    }

    private void doUpgrade(final Storage.StorageDirectory bpSd, final NamespaceInfo nsInfo, List<Callable<Storage.StorageDirectory>> callables, final Configuration conf) throws IOException {
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            return;
        }
        final int oldLV = this.getLayoutVersion();
        LOG.info("Upgrading block pool storage directory " + bpSd.getRoot() + ".\n   old LV = " + oldLV + "; old CTime = " + this.getCTime() + ".\n   new LV = " + HdfsServerConstants.DATANODE_LAYOUT_VERSION + "; new CTime = " + nsInfo.getCTime());
        String dnRoot = BlockPoolSliceStorage.getDataNodeStorageRoot(bpSd.getRoot().getCanonicalPath());
        Storage.StorageDirectory dnSdStorage = new Storage.StorageDirectory(new File(dnRoot));
        File dnPrevDir = dnSdStorage.getPreviousDir();
        if (dnPrevDir.exists()) {
            BlockPoolSliceStorage.deleteDir(dnPrevDir);
        }
        final File bpCurDir = bpSd.getCurrentDir();
        final File bpPrevDir = bpSd.getPreviousDir();
        assert (bpCurDir.exists()) : "BP level current directory must exist.";
        this.cleanupDetachDir(new File(bpCurDir, "detach"));
        if (bpPrevDir.exists()) {
            BlockPoolSliceStorage.deleteDir(bpPrevDir);
        }
        final File bpTmpDir = bpSd.getPreviousTmp();
        assert (!bpTmpDir.exists()) : "previous.tmp directory must not exist.";
        BlockPoolSliceStorage.rename(bpCurDir, bpTmpDir);
        final String name = "block pool " + this.blockpoolID + " at " + bpSd.getRoot();
        if (callables == null) {
            this.doUpgrade(name, bpSd, nsInfo, bpPrevDir, bpTmpDir, bpCurDir, oldLV, conf);
        } else {
            callables.add(new Callable<Storage.StorageDirectory>(){

                @Override
                public Storage.StorageDirectory call() throws Exception {
                    BlockPoolSliceStorage.this.doUpgrade(name, bpSd, nsInfo, bpPrevDir, bpTmpDir, bpCurDir, oldLV, conf);
                    return bpSd;
                }
            });
        }
    }

    private void doUpgrade(String name, Storage.StorageDirectory bpSd, NamespaceInfo nsInfo, File bpPrevDir, File bpTmpDir, File bpCurDir, int oldLV, Configuration conf) throws IOException {
        BlockPoolSliceStorage.linkAllBlocks(bpTmpDir, bpCurDir, oldLV, conf);
        this.layoutVersion = HdfsServerConstants.DATANODE_LAYOUT_VERSION;
        assert (this.namespaceID == nsInfo.getNamespaceID()) : "Data-node and name-node layout versions must be the same.";
        this.cTime = nsInfo.getCTime();
        this.writeProperties(bpSd);
        BlockPoolSliceStorage.rename(bpTmpDir, bpPrevDir);
        LOG.info("Upgrade of " + name + " is complete");
    }

    private void cleanupDetachDir(File detachDir) throws IOException {
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.APPEND_RBW_DIR, this.layoutVersion) && detachDir.exists() && detachDir.isDirectory()) {
            if (FileUtil.list(detachDir).length != 0) {
                throw new IOException("Detached directory " + detachDir + " is not empty. Please manually move each file under this " + "directory to the finalized directory if the finalized " + "directory tree does not have the file.");
            }
            if (!detachDir.delete()) {
                throw new IOException("Cannot remove directory " + detachDir);
            }
        }
    }

    private int restoreBlockFilesFromTrash(File trashRoot) throws IOException {
        File[] children;
        int filesRestored = 0;
        File[] fileArray = children = trashRoot.exists() ? trashRoot.listFiles() : null;
        if (children == null) {
            return 0;
        }
        File restoreDirectory = null;
        for (File child : children) {
            if (child.isDirectory()) {
                filesRestored += this.restoreBlockFilesFromTrash(child);
                continue;
            }
            if (restoreDirectory == null && !(restoreDirectory = new File(this.getRestoreDirectory(child))).exists() && !restoreDirectory.mkdirs()) {
                throw new IOException("Failed to create directory " + restoreDirectory);
            }
            File newChild = new File(restoreDirectory, child.getName());
            if (newChild.exists() && newChild.length() >= child.length()) {
                LOG.info("Not overwriting " + newChild + " with smaller file from " + "trash directory. This message can be safely ignored.");
                continue;
            }
            if (!child.renameTo(newChild)) {
                throw new IOException("Failed to rename " + child + " to " + newChild);
            }
            ++filesRestored;
        }
        FileUtil.fullyDelete(trashRoot);
        return filesRestored;
    }

    void doRollback(Storage.StorageDirectory bpSd, NamespaceInfo nsInfo) throws IOException {
        File prevDir = bpSd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        BlockPoolSliceStorage prevInfo = new BlockPoolSliceStorage();
        prevInfo.readPreviousVersionProperties(bpSd);
        if (prevInfo.getLayoutVersion() < HdfsServerConstants.DATANODE_LAYOUT_VERSION || prevInfo.getCTime() > nsInfo.getCTime()) {
            throw new InconsistentFSStateException(bpSd.getRoot(), "Cannot rollback to a newer state.\nDatanode previous state: LV = " + prevInfo.getLayoutVersion() + " CTime = " + prevInfo.getCTime() + " is newer than the namespace state: LV = " + HdfsServerConstants.DATANODE_LAYOUT_VERSION + " CTime = " + nsInfo.getCTime());
        }
        LOG.info("Rolling back storage directory " + bpSd.getRoot() + ".\n   target LV = " + nsInfo.getLayoutVersion() + "; target CTime = " + nsInfo.getCTime());
        File tmpDir = bpSd.getRemovedTmp();
        assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
        File curDir = bpSd.getCurrentDir();
        assert (curDir.exists()) : "Current directory must exist.";
        BlockPoolSliceStorage.rename(curDir, tmpDir);
        BlockPoolSliceStorage.rename(prevDir, curDir);
        BlockPoolSliceStorage.deleteDir(tmpDir);
        LOG.info("Rollback of " + bpSd.getRoot() + " is complete");
    }

    void doFinalize(File dnCurDir) throws IOException {
        File bpRoot = BlockPoolSliceStorage.getBpRoot(this.blockpoolID, dnCurDir);
        Storage.StorageDirectory bpSd = new Storage.StorageDirectory(bpRoot);
        File prevDir = bpSd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        final String dataDirPath = bpSd.getRoot().getCanonicalPath();
        LOG.info("Finalizing upgrade for storage directory " + dataDirPath + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime());
        assert (bpSd.getCurrentDir().exists()) : "Current directory must exist.";
        final File tmpDir = bpSd.getFinalizedTmp();
        BlockPoolSliceStorage.rename(prevDir, tmpDir);
        new Daemon(new Runnable(){

            @Override
            public void run() {
                try {
                    Storage.deleteDir(tmpDir);
                }
                catch (IOException ex) {
                    Storage.LOG.error("Finalize upgrade for " + dataDirPath + " failed.", ex);
                }
                Storage.LOG.info("Finalize upgrade for " + dataDirPath + " is complete.");
            }

            public String toString() {
                return "Finalize " + dataDirPath;
            }
        }).start();
    }

    private static void linkAllBlocks(File fromDir, File toDir, int diskLayoutVersion, Configuration conf) throws IOException {
        HardLink hardLink = new HardLink();
        DataStorage.linkBlocks(fromDir, toDir, "finalized", diskLayoutVersion, hardLink, conf);
        DataStorage.linkBlocks(fromDir, toDir, "rbw", diskLayoutVersion, hardLink, conf);
        LOG.info("Linked blocks from " + fromDir + " to " + toDir + ". " + hardLink.linkStats.report());
    }

    private static String getDataNodeStorageRoot(String bpRoot) {
        Matcher matcher = BLOCK_POOL_PATH_PATTERN.matcher(bpRoot);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return bpRoot;
    }

    @Override
    public String toString() {
        return super.toString() + ";bpid=" + this.blockpoolID;
    }

    public static File getBpRoot(String bpID, File dnCurDir) {
        return new File(dnCurDir, bpID);
    }

    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        return false;
    }

    private File getTrashRootDir(Storage.StorageDirectory sd) {
        return new File(sd.getRoot(), TRASH_ROOT_DIR);
    }

    @VisibleForTesting
    public boolean isTrashAllowed(File blockFile) {
        Matcher matcher = BLOCK_POOL_CURRENT_PATH_PATTERN.matcher(blockFile.getParent());
        String previousDir = matcher.replaceFirst("$1$2previous");
        return !new File(previousDir).exists();
    }

    public String getTrashDirectory(File blockFile) {
        if (this.isTrashAllowed(blockFile)) {
            Matcher matcher = BLOCK_POOL_CURRENT_PATH_PATTERN.matcher(blockFile.getParent());
            String trashDirectory = matcher.replaceFirst("$1$2trash$4");
            return trashDirectory;
        }
        return null;
    }

    @VisibleForTesting
    String getRestoreDirectory(File blockFile) {
        Matcher matcher = BLOCK_POOL_TRASH_PATH_PATTERN.matcher(blockFile.getParent());
        String restoreDirectory = matcher.replaceFirst("$1$2current$4");
        LOG.info("Restoring " + blockFile + " to " + restoreDirectory);
        return restoreDirectory;
    }

    public void clearTrash() {
        final ArrayList<File> trashRoots = new ArrayList<File>();
        for (Storage.StorageDirectory sd : this.storageDirs) {
            File trashRoot = this.getTrashRootDir(sd);
            if (trashRoot.exists() && sd.getPreviousDir().exists()) {
                LOG.error("Trash and PreviousDir shouldn't both exist for storage directory " + sd);
                assert (false);
                continue;
            }
            trashRoots.add(trashRoot);
        }
        this.stopTrashCleaner();
        this.trashCleaner = new Daemon(new Runnable(){

            @Override
            public void run() {
                for (File trashRoot : trashRoots) {
                    FileUtil.fullyDelete(trashRoot);
                    Storage.LOG.info("Cleared trash for storage directory " + trashRoot);
                }
            }

            public String toString() {
                return "clearTrash() for " + BlockPoolSliceStorage.this.blockpoolID;
            }
        });
        this.trashCleaner.start();
    }

    public void stopTrashCleaner() {
        if (this.trashCleaner != null) {
            this.trashCleaner.interrupt();
        }
    }

    @VisibleForTesting
    public boolean trashEnabled() {
        for (Storage.StorageDirectory sd : this.storageDirs) {
            if (!this.getTrashRootDir(sd).exists()) continue;
            return true;
        }
        return false;
    }

    public void setRollingUpgradeMarkers(List<Storage.StorageDirectory> dnStorageDirs) throws IOException {
        for (Storage.StorageDirectory sd : dnStorageDirs) {
            File bpRoot = BlockPoolSliceStorage.getBpRoot(this.blockpoolID, sd.getCurrentDir());
            File markerFile = new File(bpRoot, ROLLING_UPGRADE_MARKER_FILE);
            if (storagesWithRollingUpgradeMarker.contains(bpRoot.toString())) continue;
            if (!markerFile.exists() && markerFile.createNewFile()) {
                LOG.info("Created " + markerFile);
            } else {
                LOG.info(markerFile + " already exists.");
            }
            storagesWithRollingUpgradeMarker.add(bpRoot.toString());
            storagesWithoutRollingUpgradeMarker.remove(bpRoot.toString());
        }
    }

    public void clearRollingUpgradeMarkers(List<Storage.StorageDirectory> dnStorageDirs) throws IOException {
        for (Storage.StorageDirectory sd : dnStorageDirs) {
            File bpRoot = BlockPoolSliceStorage.getBpRoot(this.blockpoolID, sd.getCurrentDir());
            File markerFile = new File(bpRoot, ROLLING_UPGRADE_MARKER_FILE);
            if (storagesWithoutRollingUpgradeMarker.contains(bpRoot.toString())) continue;
            if (markerFile.exists()) {
                LOG.info("Deleting " + markerFile);
                this.doFinalize(sd.getCurrentDir());
                if (!markerFile.delete()) {
                    LOG.warn("Failed to delete " + markerFile);
                }
            }
            storagesWithoutRollingUpgradeMarker.add(bpRoot.toString());
            storagesWithRollingUpgradeMarker.remove(bpRoot.toString());
        }
    }
}

