/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static Object invokeConstructor(Class klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[]{arg};
        return ConstructorUtils.invokeConstructor(klass, args);
    }

    public static Object invokeConstructor(Class klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == args) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return ConstructorUtils.invokeConstructor(klass, args, parameterTypes);
    }

    public static Object invokeConstructor(Class klass, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor ctor;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (null == (ctor = ConstructorUtils.getMatchingAccessibleConstructor(klass, parameterTypes))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static Object invokeExactConstructor(Class klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[]{arg};
        return ConstructorUtils.invokeExactConstructor(klass, args);
    }

    public static Object invokeExactConstructor(Class klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == args) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return ConstructorUtils.invokeExactConstructor(klass, args, parameterTypes);
    }

    public static Object invokeExactConstructor(Class klass, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor ctor;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (null == (ctor = ConstructorUtils.getAccessibleConstructor(klass, parameterTypes))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static Constructor getAccessibleConstructor(Class klass, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return ConstructorUtils.getAccessibleConstructor(klass, parameterTypes);
    }

    public static Constructor getAccessibleConstructor(Class klass, Class[] parameterTypes) {
        try {
            return ConstructorUtils.getAccessibleConstructor(klass.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Constructor getAccessibleConstructor(Constructor ctor) {
        if (ctor == null) {
            return null;
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            return null;
        }
        Class clazz = ctor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return ctor;
        }
        return null;
    }

    private static Constructor getMatchingAccessibleConstructor(Class clazz, Class[] parameterTypes) {
        try {
            Constructor ctor = clazz.getConstructor(parameterTypes);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            return ctor;
        }
        catch (NoSuchMethodException e) {
            int paramSize = parameterTypes.length;
            Constructor<?>[] ctors = clazz.getConstructors();
            int size = ctors.length;
            for (int i = 0; i < size; ++i) {
                Constructor ctor;
                Class<?>[] ctorParams = ctors[i].getParameterTypes();
                int ctorParamSize = ctorParams.length;
                if (ctorParamSize != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < ctorParamSize; ++n) {
                    if (MethodUtils.isAssignmentCompatible(ctorParams[n], parameterTypes[n])) continue;
                    match = false;
                    break;
                }
                if (!match || (ctor = ConstructorUtils.getAccessibleConstructor(ctors[i])) == null) continue;
                try {
                    ctor.setAccessible(true);
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                return ctor;
            }
            return null;
        }
    }
}

