/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncCountTrigger;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncTrigger;
import org.apache.flink.streaming.api.windowing.triggers.AsyncProcessingTimeoutTrigger;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeoutTrigger;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.AsyncTriggerConverter;
import org.apache.flink.streaming.runtime.operators.windowing.AsyncTriggerTestHarness;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ProcessingTimeoutTriggerTest {
    ProcessingTimeoutTriggerTest() {
    }

    @ParameterizedTest(name="Enable async state = {0}")
    @ValueSource(booleans={false, true})
    void testWindowFireWithoutResetTimer(boolean enableAsyncState) throws Exception {
        ProcessingTimeoutTrigger trigger = ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)true);
        AsyncTriggerTestHarness testHarness = enableAsyncState ? new AsyncTriggerTestHarness(AsyncTriggerConverter.convertToAsync((Trigger)trigger), (TypeSerializer)new TimeWindow.Serializer()) : new TriggerTestHarness((Trigger)trigger, (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> ProcessingTimeoutTriggerTest.lambda$testWindowFireWithoutResetTimer$0((TriggerTestHarness)testHarness));
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(-9223372036854775758L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
    }

    @ParameterizedTest(name="Enable async state = {0}")
    @ValueSource(booleans={false, true})
    void testWindowFireWithResetTimer(boolean enableAsyncState) throws Exception {
        ProcessingTimeoutTrigger trigger = ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)true, (boolean)true);
        AsyncTriggerTestHarness testHarness = enableAsyncState ? new AsyncTriggerTestHarness(AsyncTriggerConverter.convertToAsync((Trigger)trigger), (TypeSerializer)new TimeWindow.Serializer()) : new TriggerTestHarness((Trigger)trigger, (TypeSerializer)new TimeWindow.Serializer());
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> ProcessingTimeoutTriggerTest.lambda$testWindowFireWithResetTimer$1((TriggerTestHarness)testHarness));
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> ProcessingTimeoutTriggerTest.lambda$testWindowFireWithResetTimer$2((TriggerTestHarness)testHarness));
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> ProcessingTimeoutTriggerTest.lambda$testWindowFireWithResetTimer$3((TriggerTestHarness)testHarness));
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(60L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1, 0L), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1, 10L), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1, 20L), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
    }

    @ParameterizedTest(name="Enable async state = {0}")
    @ValueSource(booleans={false, true})
    void testWindowFireWithoutClearOnTimeout(boolean enableAsyncState) throws Exception {
        ProcessingTimeoutTrigger trigger = ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)false);
        AsyncTriggerTestHarness testHarness = enableAsyncState ? new AsyncTriggerTestHarness(AsyncTriggerConverter.convertToAsync((Trigger)trigger), (TypeSerializer)new TimeWindow.Serializer()) : new TriggerTestHarness((Trigger)trigger, (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(-9223372036854775758L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @ParameterizedTest(name="Enable async state = {0}")
    @ValueSource(booleans={false, true})
    void testWindowPurgingWhenInnerTriggerIsPurging(boolean enableAsyncState) throws Exception {
        ProcessingTimeoutTrigger trigger = ProcessingTimeoutTrigger.of((Trigger)PurgingTrigger.of((Trigger)ProcessingTimeTrigger.create()), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)false);
        AsyncTriggerTestHarness testHarness = enableAsyncState ? new AsyncTriggerTestHarness(AsyncTriggerConverter.convertToAsync((Trigger)trigger), (TypeSerializer)new TimeWindow.Serializer()) : new TriggerTestHarness((Trigger)trigger, (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(-9223372036854775758L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE_AND_PURGE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @Test
    void testConvertToAsync() {
        ProcessingTimeoutTrigger syncTrigger = ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)2333L), (Duration)Duration.ofMillis(233L), (boolean)false, (boolean)false);
        AsyncTrigger asyncTrigger = AsyncTriggerConverter.convertToAsync((Trigger)syncTrigger);
        Assertions.assertThat((Object)asyncTrigger).isInstanceOf(AsyncProcessingTimeoutTrigger.class);
        AsyncProcessingTimeoutTrigger asyncProcessingTimeoutTrigger = (AsyncProcessingTimeoutTrigger)asyncTrigger;
        Assertions.assertThat((long)asyncProcessingTimeoutTrigger.getInterval()).isEqualTo(233L);
        Assertions.assertThat((boolean)asyncProcessingTimeoutTrigger.isResetTimerOnNewRecord()).isFalse();
        Assertions.assertThat((boolean)asyncProcessingTimeoutTrigger.isShouldClearOnTimeout()).isFalse();
        AsyncTrigger nestedTrigger = asyncProcessingTimeoutTrigger.getNestedTrigger();
        Assertions.assertThat((Object)nestedTrigger).isInstanceOf(AsyncCountTrigger.class);
        Assertions.assertThat((String)nestedTrigger.toString()).isEqualTo("AsyncCountTrigger(2333)");
    }

    private static /* synthetic */ Object lambda$testWindowFireWithResetTimer$3(TriggerTestHarness testHarness) throws Exception {
        return testHarness.advanceProcessingTime(50L, (Window)new TimeWindow(0L, 2L));
    }

    private static /* synthetic */ Object lambda$testWindowFireWithResetTimer$2(TriggerTestHarness testHarness) throws Exception {
        return testHarness.advanceProcessingTime(10L, (Window)new TimeWindow(0L, 2L));
    }

    private static /* synthetic */ Object lambda$testWindowFireWithResetTimer$1(TriggerTestHarness testHarness) throws Exception {
        return testHarness.advanceProcessingTime(0L, (Window)new TimeWindow(0L, 2L));
    }

    private static /* synthetic */ Object lambda$testWindowFireWithoutResetTimer$0(TriggerTestHarness testHarness) throws Exception {
        return testHarness.advanceProcessingTime(-9223372036854775768L, (Window)new TimeWindow(0L, 2L));
    }
}

