/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.OptionalLong;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobInfo;
import org.apache.flink.api.common.JobInfoImpl;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.WriterInitContext;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricsGroupTestUtils;
import org.apache.flink.streaming.api.functions.sink.PrintSink;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.SimpleUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.function.ThrowingRunnable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PrintSinkTest {
    private final PrintStream originalSystemOut = System.out;
    private final PrintStream originalSystemErr = System.err;
    private final ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream arrayErrorStream = new ByteArrayOutputStream();
    private final String line = System.lineSeparator();

    PrintSinkTest() {
    }

    @BeforeEach
    void setUp() {
        System.setOut(new PrintStream(this.arrayOutputStream));
        System.setErr(new PrintStream(this.arrayErrorStream));
    }

    @AfterEach
    void tearDown() {
        if (System.out != this.originalSystemOut) {
            System.out.close();
        }
        if (System.err != this.originalSystemErr) {
            System.err.close();
        }
        System.setOut(this.originalSystemOut);
        System.setErr(this.originalSystemErr);
    }

    @Test
    void testPrintSinkStdOut() throws Exception {
        PrintSink printSink = new PrintSink();
        try (SinkWriter writer = printSink.createWriter((WriterInitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
            Assertions.assertThat((Object)this.arrayOutputStream).hasToString("hello world!" + this.line);
        }
    }

    @Test
    void testPrintSinkStdErr() throws Exception {
        PrintSink printSink = new PrintSink(true);
        try (SinkWriter writer = printSink.createWriter((WriterInitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assertions.assertThat((Object)printSink).hasToString("Print to System.err");
            Assertions.assertThat((Object)this.arrayErrorStream).hasToString("hello world!" + this.line);
        }
    }

    @Test
    void testPrintSinkStdErrWithIdentifier() throws Exception {
        PrintSink printSink = new PrintSink("mySink", true);
        try (SinkWriter writer = printSink.createWriter((WriterInitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assertions.assertThat((Object)printSink).hasToString("Print to System.err");
            Assertions.assertThat((Object)this.arrayErrorStream).hasToString("mySink> hello world!" + this.line);
        }
    }

    @Test
    void testPrintSinkWithPrefix() throws Exception {
        PrintSink printSink = new PrintSink();
        try (SinkWriter writer = printSink.createWriter((WriterInitContext)new MockInitContext(2));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
            Assertions.assertThat((Object)this.arrayOutputStream).hasToString("1> hello world!" + this.line);
        }
    }

    @Test
    void testPrintSinkWithIdentifierAndPrefix() throws Exception {
        PrintSink printSink = new PrintSink("mySink");
        try (SinkWriter writer = printSink.createWriter((WriterInitContext)new MockInitContext(2));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
            Assertions.assertThat((Object)this.arrayOutputStream).hasToString("mySink:1> hello world!" + this.line);
        }
    }

    @Test
    void testPrintSinkWithIdentifierButNoPrefix() throws Exception {
        PrintSink printSink = new PrintSink("mySink");
        try (SinkWriter writer = printSink.createWriter((WriterInitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
            Assertions.assertThat((Object)this.arrayOutputStream).hasToString("mySink> hello world!" + this.line);
        }
    }

    private static class DummyMailboxExecutor
    implements MailboxExecutor {
        private DummyMailboxExecutor() {
        }

        public void execute(MailboxExecutor.MailOptions mailOptions, ThrowingRunnable<? extends Exception> command, String descriptionFormat, Object ... descriptionArgs) {
        }

        public void yield() throws InterruptedException, FlinkRuntimeException {
        }

        public boolean tryYield() throws FlinkRuntimeException {
            return false;
        }

        public boolean shouldInterrupt() {
            return false;
        }
    }

    private static class MockInitContext
    implements WriterInitContext,
    SerializationSchema.InitializationContext {
        private final JobInfo jobInfo = new JobInfoImpl(new JobID(), "MockJob");
        private final TaskInfo taskInfo;

        private MockInitContext(int numSubtasks) {
            this.taskInfo = new TaskInfoImpl("MockTask", numSubtasks + 1, 0, numSubtasks, 0);
        }

        public UserCodeClassLoader getUserCodeClassLoader() {
            return SimpleUserCodeClassLoader.create((ClassLoader)PrintSinkTest.class.getClassLoader());
        }

        public MailboxExecutor getMailboxExecutor() {
            return new DummyMailboxExecutor();
        }

        public ProcessingTimeService getProcessingTimeService() {
            return new TestProcessingTimeService();
        }

        public SinkWriterMetricGroup metricGroup() {
            return MetricsGroupTestUtils.mockWriterMetricGroup();
        }

        public MetricGroup getMetricGroup() {
            return this.metricGroup();
        }

        public OptionalLong getRestoredCheckpointId() {
            return OptionalLong.empty();
        }

        public SerializationSchema.InitializationContext asSerializationSchemaInitializationContext() {
            return this;
        }

        public boolean isObjectReuseEnabled() {
            return false;
        }

        public <IN> TypeSerializer<IN> createInputSerializer() {
            return null;
        }

        public JobInfo getJobInfo() {
            return this.jobInfo;
        }

        public TaskInfo getTaskInfo() {
            return this.taskInfo;
        }
    }

    private static class MockContext
    implements SinkWriter.Context {
        private MockContext() {
        }

        public long currentWatermark() {
            return 0L;
        }

        public Long timestamp() {
            return System.currentTimeMillis();
        }
    }
}

