/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskTestHarness;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTask;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamTaskTestHarnessTest {
    StreamTaskTestHarnessTest() {
    }

    @Test
    void testMultipleSetupsThrowsException() {
        StreamTaskTestHarness harness = new StreamTaskTestHarness(OneInputStreamTask::new, BasicTypeInfo.STRING_TYPE_INFO);
        harness.setupOutputForSingletonOperatorChain();
        Assertions.assertThatThrownBy(harness::setupOutputForSingletonOperatorChain).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> harness.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TestOperator())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> harness.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TwoInputTestOperator())).isInstanceOf(IllegalStateException.class);
        StreamTaskTestHarness harness1 = new StreamTaskTestHarness(OneInputStreamTask::new, BasicTypeInfo.STRING_TYPE_INFO);
        harness1.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TestOperator()).chain(new OperatorID(), new TestOperator(), BasicTypeInfo.STRING_TYPE_INFO.createSerializer((SerializerConfig)new SerializerConfigImpl()));
        Assertions.assertThatThrownBy(harness1::setupOutputForSingletonOperatorChain).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> harness1.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TestOperator())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> harness1.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TwoInputTestOperator())).isInstanceOf(IllegalStateException.class);
        StreamTaskTestHarness harness2 = new StreamTaskTestHarness(TwoInputStreamTask::new, BasicTypeInfo.STRING_TYPE_INFO);
        harness2.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TwoInputTestOperator()).chain(new OperatorID(), new TestOperator(), BasicTypeInfo.STRING_TYPE_INFO.createSerializer((SerializerConfig)new SerializerConfigImpl()));
        Assertions.assertThatThrownBy(harness2::setupOutputForSingletonOperatorChain).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> harness2.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TestOperator())).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> harness2.setupOperatorChain(new OperatorID(), (StreamOperator<?>)new TwoInputTestOperator())).isInstanceOf(IllegalStateException.class);
    }

    private static class TwoInputTestOperator
    extends AbstractStreamOperator<String>
    implements TwoInputStreamOperator<String, String, String> {
        private TwoInputTestOperator() {
        }

        public void processElement1(StreamRecord<String> element) throws Exception {
        }

        public void processElement2(StreamRecord<String> element) throws Exception {
        }
    }

    private static class TestOperator
    extends AbstractStreamOperator<String>
    implements OneInputStreamOperator<String, String> {
        private TestOperator() {
        }

        public void processElement(StreamRecord<String> element) throws Exception {
        }
    }
}

