/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TimeWindowTranslationTest {
    TimeWindowTranslationTest() {
    }

    @Test
    void testAlignedWindowDeprecation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform1 = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator1 = transform1.getOperator();
        Assertions.assertThat((Object)operator1).isInstanceOf(WindowOperator.class);
        SingleOutputStreamOperator window2 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(Tuple tuple, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
            }
        });
        OneInputTransformation transform2 = (OneInputTransformation)window2.getTransformation();
        OneInputStreamOperator operator2 = transform2.getOperator();
        Assertions.assertThat((Object)operator2).isInstanceOf(WindowOperator.class);
    }

    @Test
    void testReduceEventTimeWindows() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).reduce((ReduceFunction)new DummyReducer());
        OneInputTransformation transform1 = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator1 = transform1.getOperator();
        Assertions.assertThat((Object)operator1).isInstanceOf(WindowOperator.class);
        WindowOperator winOperator1 = (WindowOperator)operator1;
        Assertions.assertThat((Object)winOperator1.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator1.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator1.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
    }

    @Test
    void testApplyEventTimeWindows() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(Tuple tuple, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
            }
        });
        OneInputTransformation transform1 = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator1 = transform1.getOperator();
        Assertions.assertThat((Object)operator1).isInstanceOf(WindowOperator.class);
        WindowOperator winOperator1 = (WindowOperator)operator1;
        Assertions.assertThat((Object)winOperator1.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator1.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator1.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
    }

    private static class DummyReducer
    implements ReduceFunction<Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        private DummyReducer() {
        }

        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
            return value1;
        }
    }
}

