/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

class CheckpointSequenceValidator
extends AbstractInvokable {
    private final long[] checkpointIDs;
    private int i = 0;

    CheckpointSequenceValidator(long ... checkpointIDs) {
        super((Environment)new DummyEnvironment("test", 1, 0));
        this.checkpointIDs = checkpointIDs;
    }

    public void invoke() {
        throw new UnsupportedOperationException("should never be called");
    }

    public CompletableFuture<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        throw new UnsupportedOperationException("should never be called");
    }

    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetricsBuilder checkpointMetrics) {
        ((AbstractLongArrayAssert)Assertions.assertThat((long[])this.checkpointIDs).as("Unexpected triggerCheckpointOnBarrier(" + checkpointMetaData.getCheckpointId() + ")", new Object[0])).hasSizeGreaterThan(this.i);
        long expectedId = this.checkpointIDs[this.i++];
        ((AbstractLongAssert)Assertions.assertThat((long)expectedId).as("got 'triggerCheckpointOnBarrier(%d)' when expecting an 'abortCheckpointOnBarrier(%d)'", new Object[]{checkpointMetaData.getCheckpointId(), expectedId})).isGreaterThanOrEqualTo(0L);
        Assertions.assertThat((long)checkpointMetaData.getCheckpointId()).isEqualTo(expectedId);
        Assertions.assertThat((long)checkpointMetaData.getTimestamp()).isPositive();
    }

    public void abortCheckpointOnBarrier(long checkpointId, CheckpointException cause) {
        ((AbstractLongArrayAssert)Assertions.assertThat((long[])this.checkpointIDs).as("Unexpected abortCheckpointOnBarrier(" + checkpointId + ")", new Object[0])).hasSizeGreaterThan(this.i);
        long expectedId = this.checkpointIDs[this.i++];
        ((AbstractLongAssert)Assertions.assertThat((long)expectedId).as("got 'abortCheckpointOnBarrier(%d)' when expecting an 'triggerCheckpointOnBarrier(%d)'", new Object[]{checkpointId, expectedId})).isNegative();
        ((AbstractLongAssert)Assertions.assertThat((long)checkpointId).as("wrong checkpoint id for checkpoint abort", new Object[0])).isEqualTo(-expectedId);
    }

    public Future<Void> notifyCheckpointCompleteAsync(long checkpointId) {
        throw new UnsupportedOperationException("should never be called");
    }
}

