/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.operators.collect.utils.AbstractTestCoordinationRequestHandler;

public class TestUncheckpointedCoordinationRequestHandler<T>
extends AbstractTestCoordinationRequestHandler<T> {
    private int failCount;
    private final LinkedList<T> originalData;
    private LinkedList<T> data;

    public TestUncheckpointedCoordinationRequestHandler(int failCount, List<T> data, TypeSerializer<T> serializer, String accumulatorName) {
        super(serializer, accumulatorName);
        this.failCount = failCount;
        this.originalData = new LinkedList<T>(data);
        this.data = new LinkedList<T>(data);
        this.closed = false;
    }

    @Override
    protected void updateBufferedResults() {
        for (int i = this.random.nextInt(3) + 1; i > 0; --i) {
            int r = this.random.nextInt(20);
            if (r < 19 || this.failCount <= 0) {
                int size = Math.min(this.data.size(), 6 - this.buffered.size());
                if (size > 0) {
                    size = this.random.nextInt(size) + 1;
                }
                for (int j = 0; j < size; ++j) {
                    this.buffered.add(this.data.removeFirst());
                }
                if (!this.data.isEmpty()) continue;
                this.buildAccumulatorResults();
                this.closed = true;
                break;
            }
            --this.failCount;
            this.data = new LinkedList<T>(this.originalData);
            Collections.shuffle(this.data);
            this.buffered = new LinkedList();
            this.version = UUID.randomUUID().toString();
            this.offset = 0L;
        }
    }
}

