/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ListCheckpointedTest {
    ListCheckpointedTest() {
    }

    @Test
    void testUDFReturningNull() throws Exception {
        ListCheckpointedTest.testUDF(new TestUserFunction(null));
    }

    @Test
    void testUDFReturningEmpty() throws Exception {
        ListCheckpointedTest.testUDF(new TestUserFunction(Collections.emptyList()));
    }

    @Test
    void testUDFReturningData() throws Exception {
        ListCheckpointedTest.testUDF(new TestUserFunction(Arrays.asList(1, 2, 3)));
    }

    private static void testUDF(TestUserFunction userFunction) throws Exception {
        OperatorSubtaskState snapshot;
        try (AbstractStreamOperatorTestHarness<Integer> testHarness = ListCheckpointedTest.createTestHarness(userFunction);){
            testHarness.open();
            snapshot = testHarness.snapshot(0L, 0L);
            Assertions.assertThat((boolean)userFunction.isRestored()).isFalse();
        }
        testHarness = ListCheckpointedTest.createTestHarness(userFunction);
        var3_2 = null;
        try {
            testHarness.initializeState(snapshot);
            testHarness.open();
            Assertions.assertThat((boolean)userFunction.isRestored()).isTrue();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (testHarness != null) {
                if (var3_2 != null) {
                    try {
                        testHarness.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    testHarness.close();
                }
            }
        }
    }

    private static AbstractStreamOperatorTestHarness<Integer> createTestHarness(TestUserFunction userFunction) throws Exception {
        return new AbstractStreamOperatorTestHarness<Integer>((StreamOperator<Integer>)new StreamMap((MapFunction)userFunction), 1, 1, 0);
    }

    private static class TestUserFunction
    extends RichMapFunction<Integer, Integer>
    implements ListCheckpointed<Integer> {
        private static final long serialVersionUID = -8981369286399531925L;
        private final List<Integer> expected;
        private boolean restored;

        public TestUserFunction(List<Integer> expected) {
            this.expected = expected;
            this.restored = false;
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }

        public List<Integer> snapshotState(long checkpointId, long timestamp) throws Exception {
            return this.expected;
        }

        public void restoreState(List<Integer> state) throws Exception {
            if (null != this.expected) {
                Assertions.assertThat(state).isEqualTo(this.expected);
            } else {
                Assertions.assertThat(state).isEmpty();
            }
            this.restored = true;
        }

        public boolean isRestored() {
            return this.restored;
        }
    }
}

