/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;

public abstract class AbstractBroadcastStreamOperatorTestHarness<IN1, IN2, OUT>
extends AbstractStreamOperatorTestHarness<OUT> {
    public AbstractBroadcastStreamOperatorTestHarness(StreamOperator<OUT> operator, int maxParallelism, int parallelism, int subtaskIndex) throws Exception {
        super(operator, maxParallelism, parallelism, subtaskIndex);
    }

    public TwoInputStreamOperator<IN1, IN2, OUT> getTwoInputOperator() {
        return (TwoInputStreamOperator)this.operator;
    }

    public void processElement(StreamRecord<IN1> element) throws Exception {
        this.getTwoInputOperator().setKeyContextElement1(element);
        this.getTwoInputOperator().processElement1(element);
    }

    public void processElement(IN1 value, long timestamp) throws Exception {
        this.processElement(new StreamRecord(value, timestamp));
    }

    public void processBroadcastElement(StreamRecord<IN2> element) throws Exception {
        this.getTwoInputOperator().setKeyContextElement2(element);
        this.getTwoInputOperator().processElement2(element);
    }

    public void processBroadcastElement(IN2 value, long timestamp) throws Exception {
        StreamRecord element = new StreamRecord(value, timestamp);
        this.processBroadcastElement(element);
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.getOperator().processWatermark1(mark);
    }

    public void processBroadcastWatermark(Watermark mark) throws Exception {
        this.getOperator().processWatermark2(mark);
    }

    public void processWatermark(long timestamp) throws Exception {
        Watermark mark = new Watermark(timestamp);
        this.getOperator().processWatermark1(mark);
    }

    public void processBroadcastWatermark(long timestamp) throws Exception {
        Watermark mark = new Watermark(timestamp);
        this.getOperator().processWatermark2(mark);
    }

    public void watermark(long timestamp) throws Exception {
        this.processWatermark(new Watermark(timestamp));
        this.processBroadcastWatermark(new Watermark(timestamp));
    }
}

