/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobInfo;
import org.apache.flink.api.common.JobInfoImpl;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.RecordOrEventCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.TestGlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.NoOpCheckpointResponder;
import org.apache.flink.runtime.taskmanager.NoOpTaskManagerActions;
import org.apache.flink.runtime.taskmanager.NoOpTaskOperatorEventGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingUserCodeClassLoader;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.UserCodeClassLoader;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;

public class StreamMockEnvironment
implements Environment {
    private final JobInfo jobInfo;
    private final TaskInfo taskInfo;
    private final MemoryManager memManager;
    private final SharedResources sharedResources;
    private final IOManager ioManager;
    private final InputSplitProvider inputSplitProvider;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final List<IndexedInputGate> inputs;
    private List<ResultPartitionWriter> outputs;
    private final ExecutionAttemptID executionAttemptID;
    private final BroadcastVariableManager bcVarManager = new BroadcastVariableManager();
    private final AccumulatorRegistry accumulatorRegistry;
    private final TaskKvStateRegistry kvStateRegistry;
    private final int bufferSize;
    private final ExecutionConfig executionConfig;
    private final TaskStateManager taskStateManager;
    private final GlobalAggregateManager aggregateManager;
    private final UserCodeClassLoader userCodeClassLoader = TestingUserCodeClassLoader.newBuilder().build();
    private final boolean collectNetworkEvents;
    private final ChannelStateWriteRequestExecutorFactory channelStateExecutorFactory;
    @Nullable
    private Consumer<Throwable> externalExceptionHandler;
    private TaskEventDispatcher taskEventDispatcher = (TaskEventDispatcher)Mockito.mock(TaskEventDispatcher.class);
    private TaskManagerRuntimeInfo taskManagerRuntimeInfo = new TestingTaskManagerRuntimeInfo();
    private TaskMetricGroup taskMetricGroup = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
    private CheckpointResponder checkpointResponder = NoOpCheckpointResponder.INSTANCE;
    private CheckpointStorageAccess checkpointStorageAccess;

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager) {
        this(new JobID(), ExecutionGraphTestUtils.createExecutionAttemptId(), jobConfig, taskConfig, executionConfig, memorySize, inputSplitProvider, bufferSize, taskStateManager, false);
    }

    public StreamMockEnvironment(JobID jobID, ExecutionAttemptID executionAttemptID, Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long offHeapMemorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager, boolean collectNetworkEvents) {
        this.jobInfo = new JobInfoImpl(jobID, "mock");
        this.executionAttemptID = executionAttemptID;
        int subtaskIndex = executionAttemptID.getExecutionVertexId().getSubtaskIndex();
        this.taskInfo = new TaskInfoImpl("", 1, subtaskIndex, 1, executionAttemptID.getAttemptNumber());
        this.jobConfiguration = jobConfig;
        this.taskConfiguration = taskConfig;
        this.inputs = new LinkedList<IndexedInputGate>();
        this.outputs = new LinkedList<ResultPartitionWriter>();
        this.memManager = MemoryManagerBuilder.newBuilder().setMemorySize(offHeapMemorySize).build();
        this.sharedResources = new SharedResources();
        this.ioManager = new IOManagerAsync();
        this.taskStateManager = (TaskStateManager)Preconditions.checkNotNull((Object)taskStateManager);
        this.aggregateManager = new TestGlobalAggregateManager();
        this.inputSplitProvider = inputSplitProvider;
        this.bufferSize = bufferSize;
        this.executionConfig = executionConfig;
        this.accumulatorRegistry = new AccumulatorRegistry(jobID, this.getExecutionId());
        KvStateRegistry registry = new KvStateRegistry();
        this.kvStateRegistry = registry.createTaskRegistry(jobID, executionAttemptID.getExecutionVertexId().getJobVertexId());
        this.collectNetworkEvents = collectNetworkEvents;
        this.channelStateExecutorFactory = new ChannelStateWriteRequestExecutorFactory(jobID);
    }

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager) {
        this(jobConfig, taskConfig, new ExecutionConfig(), memorySize, inputSplitProvider, bufferSize, taskStateManager);
    }

    public void addInputGate(IndexedInputGate gate) {
        this.inputs.add(gate);
    }

    public <T> void addOutput(Collection<Object> outputList, TypeSerializer<T> serializer) {
        this.addOutput((ResultPartitionWriter)new RecordOrEventCollectingResultPartitionWriter(outputList, serializer, this.collectNetworkEvents));
    }

    public void addOutput(ResultPartitionWriter resultPartitionWriter) {
        try {
            this.outputs.add(resultPartitionWriter);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assertions.fail((String)t.getMessage());
        }
    }

    public void setOutputs(List<ResultPartitionWriter> outputs) {
        this.outputs = outputs;
    }

    public void setExternalExceptionHandler(Consumer<Throwable> externalExceptionHandler) {
        this.externalExceptionHandler = externalExceptionHandler;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    public SharedResources getSharedResources() {
        return this.sharedResources;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public JobID getJobID() {
        return this.jobInfo.getJobId();
    }

    public JobType getJobType() {
        return JobType.STREAMING;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.inputSplitProvider;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public ResultPartitionWriter getWriter(int index) {
        return this.outputs.get(index);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return this.outputs.toArray(new ResultPartitionWriter[this.outputs.size()]);
    }

    public IndexedInputGate getInputGate(int index) {
        return this.inputs.get(index);
    }

    public IndexedInputGate[] getAllInputGates() {
        return this.inputs.toArray(new IndexedInputGate[0]);
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        return this.taskEventDispatcher;
    }

    public JobVertexID getJobVertexId() {
        return new JobVertexID(new byte[16]);
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionAttemptID;
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    public TaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    public GlobalAggregateManager getGlobalAggregateManager() {
        return this.aggregateManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.kvStateRegistry;
    }

    public ExternalResourceInfoProvider getExternalResourceInfoProvider() {
        return ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES;
    }

    public TaskManagerActions getTaskManagerActions() {
        return new NoOpTaskManagerActions();
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        this.taskStateManager.reportTaskStateSnapshots(new CheckpointMetaData(checkpointId, 0L), checkpointMetrics, subtaskState, null);
    }

    public void declineCheckpoint(long checkpointId, CheckpointException checkpointException) {
        this.checkpointResponder.declineCheckpoint(this.jobInfo.getJobId(), this.executionAttemptID, checkpointId, checkpointException);
    }

    public TaskOperatorEventGateway getOperatorCoordinatorEventGateway() {
        return new NoOpTaskOperatorEventGateway();
    }

    public void failExternally(Throwable cause) {
        if (this.externalExceptionHandler != null) {
            this.externalExceptionHandler.accept(cause);
        }
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return this.taskManagerRuntimeInfo;
    }

    public void setTaskManagerInfo(TaskManagerRuntimeInfo taskManagerRuntimeInfo) {
        this.taskManagerRuntimeInfo = taskManagerRuntimeInfo;
    }

    public TaskMetricGroup getMetricGroup() {
        return this.taskMetricGroup;
    }

    public void setTaskMetricGroup(TaskMetricGroup taskMetricGroup) {
        this.taskMetricGroup = taskMetricGroup;
    }

    public void setCheckpointResponder(CheckpointResponder checkpointResponder) {
        this.checkpointResponder = checkpointResponder;
    }

    public ChannelStateWriteRequestExecutorFactory getChannelStateExecutorFactory() {
        return this.channelStateExecutorFactory;
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public void setCheckpointStorageAccess(CheckpointStorageAccess checkpointStorageAccess) {
        this.checkpointStorageAccess = checkpointStorageAccess;
    }

    public CheckpointStorageAccess getCheckpointStorageAccess() {
        return this.checkpointStorageAccess;
    }
}

