/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class KeyGroupStreamPartitionerTest {
    private KeyGroupStreamPartitioner<Tuple2<String, Integer>, String> keyGroupPartitioner;
    private StreamRecord<Tuple2<String, Integer>> streamRecord1 = new StreamRecord((Object)new Tuple2((Object)"test", (Object)0));
    private StreamRecord<Tuple2<String, Integer>> streamRecord2 = new StreamRecord((Object)new Tuple2((Object)"test", (Object)42));
    private SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> serializationDelegate1 = new SerializationDelegate(null);
    private SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> serializationDelegate2 = new SerializationDelegate(null);

    KeyGroupStreamPartitionerTest() {
    }

    @BeforeEach
    void setPartitioner() {
        this.keyGroupPartitioner = new KeyGroupStreamPartitioner((KeySelector)new KeySelector<Tuple2<String, Integer>, String>(){
            private static final long serialVersionUID = 1L;

            public String getKey(Tuple2<String, Integer> value) throws Exception {
                return (String)value.getField(0);
            }
        }, 1024);
    }

    @Test
    void testSelectChannelsGrouping() {
        this.serializationDelegate1.setInstance(this.streamRecord1);
        this.serializationDelegate2.setInstance(this.streamRecord2);
        Assertions.assertThat((int)this.selectChannels(this.serializationDelegate1, 1)).isEqualTo(this.selectChannels(this.serializationDelegate2, 1));
        Assertions.assertThat((int)this.selectChannels(this.serializationDelegate1, 2)).isEqualTo(this.selectChannels(this.serializationDelegate2, 2));
        Assertions.assertThat((int)this.selectChannels(this.serializationDelegate1, 1024)).isEqualTo(this.selectChannels(this.serializationDelegate2, 1024));
    }

    private int selectChannels(SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> serializationDelegate, int numberOfChannels) {
        this.keyGroupPartitioner.setup(numberOfChannels);
        return this.keyGroupPartitioner.selectChannel(serializationDelegate);
    }
}

