/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TimeWindowTest {
    TimeWindowTest() {
    }

    @Test
    void testGetWindowStartWithOffset() {
        long offset = 0L;
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-8L, (long)offset, (long)7L)).isEqualTo(-14L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-7L, (long)offset, (long)7L)).isEqualTo(-7L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-6L, (long)offset, (long)7L)).isEqualTo(-7L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-1L, (long)offset, (long)7L)).isEqualTo(-7L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)1L, (long)offset, (long)7L)).isZero();
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)6L, (long)offset, (long)7L)).isZero();
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)7L, (long)offset, (long)7L)).isEqualTo(7L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)8L, (long)offset, (long)7L)).isEqualTo(7L);
        offset = 3L;
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-10L, (long)offset, (long)7L)).isEqualTo(-11L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-9L, (long)offset, (long)7L)).isEqualTo(-11L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-3L, (long)offset, (long)7L)).isEqualTo(-4L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-2L, (long)offset, (long)7L)).isEqualTo(-4L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-1L, (long)offset, (long)7L)).isEqualTo(-4L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)1L, (long)offset, (long)7L)).isEqualTo(-4L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)2L, (long)offset, (long)7L)).isEqualTo(-4L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)3L, (long)offset, (long)7L)).isEqualTo(3L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)9L, (long)offset, (long)7L)).isEqualTo(3L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)10L, (long)offset, (long)7L)).isEqualTo(10L);
        offset = -2L;
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-12L, (long)offset, (long)7L)).isEqualTo(-16L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-7L, (long)offset, (long)7L)).isEqualTo(-9L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-4L, (long)offset, (long)7L)).isEqualTo(-9L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-3L, (long)offset, (long)7L)).isEqualTo(-9L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)2L, (long)offset, (long)7L)).isEqualTo(-2L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-1L, (long)offset, (long)7L)).isEqualTo(-2L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)1L, (long)offset, (long)7L)).isEqualTo(-2L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)-2L, (long)offset, (long)7L)).isEqualTo(-2L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)3L, (long)offset, (long)7L)).isEqualTo(-2L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)4L, (long)offset, (long)7L)).isEqualTo(-2L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)7L, (long)offset, (long)7L)).isEqualTo(5L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)12L, (long)offset, (long)7L)).isEqualTo(12L);
        offset = -TimeUnit.HOURS.toMillis(8L);
        long size = TimeUnit.DAYS.toMillis(1L);
        Assertions.assertThat((long)TimeWindow.getWindowStartWithOffset((long)1470902048450L, (long)offset, (long)size)).isEqualTo(1470844800000L);
    }

    private boolean intersects(TimeWindow w0, TimeWindow w1) {
        Assertions.assertThat((boolean)w0.intersects(w1)).isEqualTo(w1.intersects(w0));
        return w0.intersects(w1);
    }

    @Test
    void testIntersect() {
        TimeWindow window = new TimeWindow(10L, 20L);
        Assertions.assertThat((boolean)window.intersects(window)).isTrue();
        Assertions.assertThat((boolean)this.intersects(window, new TimeWindow(20L, 30L))).isTrue();
        Assertions.assertThat((boolean)this.intersects(window, new TimeWindow(21L, 30L))).isFalse();
        Assertions.assertThat((boolean)this.intersects(window, new TimeWindow(19L, 22L))).isTrue();
    }
}

