/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.util;

import java.time.Duration;
import org.apache.flink.streaming.api.operators.util.PausableRelativeClock;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PausableRelativeClockTest {
    private static final long TIME_STEP = 14L;

    PausableRelativeClockTest() {
    }

    @Test
    void simpleTest() {
        ManualClock baseClock = new ManualClock();
        PausableRelativeClock relativeClock = new PausableRelativeClock((Clock)baseClock);
        long startMillis = relativeClock.relativeTimeMillis();
        long startNanos = relativeClock.relativeTimeNanos();
        baseClock.advanceTime(Duration.ofMillis(14L));
        long endNanos = relativeClock.relativeTimeNanos();
        long endMillis = relativeClock.relativeTimeMillis();
        long durationNanos = endNanos - startNanos;
        long durationMillis = endMillis - startMillis;
        Assertions.assertThat((long)(durationNanos / 1000000L)).isEqualTo(14L);
        Assertions.assertThat((long)durationMillis).isEqualTo(14L);
    }

    @Test
    void pausedTest() throws Exception {
        ManualClock baseClock = new ManualClock();
        PausableRelativeClock relativeClock = new PausableRelativeClock((Clock)baseClock);
        long startMillis = relativeClock.relativeTimeMillis();
        long startNanos = relativeClock.relativeTimeNanos();
        baseClock.advanceTime(Duration.ofMillis(14L));
        relativeClock.pause();
        baseClock.advanceTime(Duration.ofMillis(14L));
        relativeClock.pause();
        baseClock.advanceTime(Duration.ofMillis(14L));
        relativeClock.unPause();
        baseClock.advanceTime(Duration.ofMillis(14L));
        relativeClock.unPause();
        baseClock.advanceTime(Duration.ofMillis(14L));
        relativeClock.pause();
        baseClock.advanceTime(Duration.ofMillis(14L));
        long endNanos = relativeClock.relativeTimeNanos();
        long endMillis = relativeClock.relativeTimeMillis();
        long durationNanos = endNanos - startNanos;
        long durationMillis = endMillis - startMillis;
        Assertions.assertThat((long)(durationNanos / 1000000L)).isEqualTo(28L);
        Assertions.assertThat((long)durationMillis).isEqualTo(28L);
    }
}

