/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.streaming.api.operators.StreamFlatMap;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.util.Collector;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamFlatMapTest {
    StreamFlatMapTest() {
    }

    @Test
    void testFlatMap() throws Exception {
        StreamFlatMap operator = new StreamFlatMap((FlatMapFunction)new MyFlatMap());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1, initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)2, initialTime + 2L));
        testHarness.processWatermark(new Watermark(initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)3, initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)4, initialTime + 4L));
        testHarness.processElement(new StreamRecord((Object)5, initialTime + 5L));
        testHarness.processElement(new StreamRecord((Object)6, initialTime + 6L));
        testHarness.processElement(new StreamRecord((Object)7, initialTime + 7L));
        testHarness.processElement(new StreamRecord((Object)8, initialTime + 8L));
        expectedOutput.add(new StreamRecord((Object)2, initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)4, initialTime + 2L));
        expectedOutput.add(new Watermark(initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)4, initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)16, initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)6, initialTime + 6L));
        expectedOutput.add(new StreamRecord((Object)36, initialTime + 6L));
        expectedOutput.add(new StreamRecord((Object)8, initialTime + 8L));
        expectedOutput.add(new StreamRecord((Object)64, initialTime + 8L));
        TestHarnessUtil.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testOpenClose() throws Exception {
        StreamFlatMap operator = new StreamFlatMap((FlatMapFunction)new TestOpenCloseFlatMapFunction());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)"Hello", initialTime));
        testHarness.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestOpenCloseFlatMapFunction.closeCalled).as("RichFunction methods where not called.", new Object[0])).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat(testHarness.getOutput()).as("Output contains no elements.", new Object[0])).isNotEmpty();
    }

    private static class TestOpenCloseFlatMapFunction
    extends RichFlatMapFunction<String, String> {
        private static final long serialVersionUID = 1L;
        public static boolean openCalled = false;
        public static boolean closeCalled = false;

        private TestOpenCloseFlatMapFunction() {
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)closeCalled).as("Close called before open.", new Object[0])).isFalse();
            openCalled = true;
        }

        public void close() throws Exception {
            super.close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before close.", new Object[0])).isTrue();
            closeCalled = true;
        }

        public void flatMap(String value, Collector<String> out) throws Exception {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before run.", new Object[0])).isTrue();
            out.collect((Object)value);
        }
    }

    private static final class MyFlatMap
    implements FlatMapFunction<Integer, Integer> {
        private static final long serialVersionUID = 1L;

        private MyFlatMap() {
        }

        public void flatMap(Integer value, Collector<Integer> out) throws Exception {
            if (value % 2 == 0) {
                out.collect((Object)value);
                out.collect((Object)(value * value));
            }
        }
    }
}

