/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.streaming.api.operators.MapPartitionIterator;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MapPartitionIteratorTest {
    private static final String RECORD = "TEST";
    private static final int RECORD_NUMBER = 3;

    MapPartitionIteratorTest() {
    }

    @Test
    void testInitialize() throws ExecutionException, InterruptedException {
        CompletableFuture result = new CompletableFuture();
        MapPartitionIterator iterator = new MapPartitionIterator(stringIterator -> result.complete(null));
        result.get();
        Assertions.assertThat(result).isCompleted();
        iterator.close();
    }

    @Test
    void testAddRecord() throws ExecutionException, InterruptedException {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture<Object> udfFinishTrigger = new CompletableFuture<Object>();
        MapPartitionIterator iterator = new MapPartitionIterator(inputIterator -> {
            ArrayList strings = new ArrayList();
            for (int index = 0; index < 3; ++index) {
                strings.add(inputIterator.next());
            }
            result.complete(strings);
            try {
                udfFinishTrigger.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        });
        this.addRecordToIterator(3, (MapPartitionIterator<String>)iterator);
        List results = (List)result.get();
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)results.get(0))).isEqualTo(RECORD);
        Assertions.assertThat((String)((String)results.get(1))).isEqualTo(RECORD);
        Assertions.assertThat((String)((String)results.get(2))).isEqualTo(RECORD);
        this.addRecordToIterator(100, (MapPartitionIterator<String>)iterator);
        CompletableFuture mockedTaskThread1 = new CompletableFuture();
        CompletableFuture addRecordFinishIdentifier1 = new CompletableFuture();
        mockedTaskThread1.thenRunAsync(() -> {
            iterator.addRecord((Object)RECORD);
            addRecordFinishIdentifier1.complete(null);
        });
        mockedTaskThread1.complete(null);
        Assertions.assertThat(addRecordFinishIdentifier1).isNotCompleted();
        iterator.next();
        addRecordFinishIdentifier1.get();
        Assertions.assertThat(addRecordFinishIdentifier1).isCompleted();
        CompletableFuture mockedTaskThread2 = new CompletableFuture();
        CompletableFuture addRecordFinishIdentifier2 = new CompletableFuture();
        mockedTaskThread2.thenRunAsync(() -> {
            iterator.addRecord((Object)RECORD);
            addRecordFinishIdentifier2.complete(null);
        });
        mockedTaskThread2.complete(null);
        Assertions.assertThat(addRecordFinishIdentifier2).isNotCompleted();
        udfFinishTrigger.complete(null);
        addRecordFinishIdentifier2.get();
        Assertions.assertThat(addRecordFinishIdentifier2).isCompleted();
        Assertions.assertThat(udfFinishTrigger).isCompleted();
        iterator.close();
    }

    @Test
    void testHasNext() throws ExecutionException, InterruptedException {
        CompletableFuture<Object> udfTrigger = new CompletableFuture<Object>();
        CompletableFuture udfReadIteratorFinishIdentifier = new CompletableFuture();
        CompletableFuture udfFinishTrigger = new CompletableFuture();
        MapPartitionIterator iterator = new MapPartitionIterator(inputIterator -> {
            try {
                udfTrigger.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
            for (int index = 0; index < 3; ++index) {
                inputIterator.next();
            }
            udfReadIteratorFinishIdentifier.complete(null);
            try {
                udfFinishTrigger.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        });
        this.addRecordToIterator(3, (MapPartitionIterator<String>)iterator);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        udfTrigger.complete(null);
        udfReadIteratorFinishIdentifier.get();
        Assertions.assertThat(udfReadIteratorFinishIdentifier).isCompleted();
        CompletableFuture mockedUDFThread1 = new CompletableFuture();
        CompletableFuture hasNextFinishIdentifier1 = new CompletableFuture();
        mockedUDFThread1.thenRunAsync(() -> {
            boolean hasNext = iterator.hasNext();
            hasNextFinishIdentifier1.complete(hasNext);
        });
        mockedUDFThread1.complete(null);
        Assertions.assertThat(hasNextFinishIdentifier1).isNotCompleted();
        iterator.addRecord((Object)RECORD);
        hasNextFinishIdentifier1.get();
        Assertions.assertThat(hasNextFinishIdentifier1).isCompletedWithValue((Object)true);
        iterator.next();
        CompletableFuture mockedUDFThread2 = new CompletableFuture();
        CompletableFuture hasNextFinishIdentifier2 = new CompletableFuture();
        mockedUDFThread2.thenRunAsync(() -> {
            boolean hasNext = iterator.hasNext();
            hasNextFinishIdentifier2.complete(hasNext);
            udfFinishTrigger.complete(null);
        });
        mockedUDFThread2.complete(null);
        Assertions.assertThat(hasNextFinishIdentifier2).isNotCompleted();
        iterator.close();
        Assertions.assertThat(hasNextFinishIdentifier2).isCompletedWithValue((Object)false);
        Assertions.assertThat(udfFinishTrigger).isCompleted();
    }

    @Test
    void testNext() throws ExecutionException, InterruptedException {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture udfFinishTrigger = new CompletableFuture();
        MapPartitionIterator iterator = new MapPartitionIterator(inputIterator -> {
            ArrayList strings = new ArrayList();
            for (int index = 0; index < 3; ++index) {
                strings.add(inputIterator.next());
            }
            result.complete(strings);
            try {
                udfFinishTrigger.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        });
        this.addRecordToIterator(3, (MapPartitionIterator<String>)iterator);
        List results = (List)result.get();
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)results.get(0))).isEqualTo(RECORD);
        Assertions.assertThat((String)((String)results.get(1))).isEqualTo(RECORD);
        Assertions.assertThat((String)((String)results.get(2))).isEqualTo(RECORD);
        CompletableFuture mockedUDFThread1 = new CompletableFuture();
        CompletableFuture nextFinishIdentifier1 = new CompletableFuture();
        mockedUDFThread1.thenRunAsync(() -> {
            String next = (String)iterator.next();
            nextFinishIdentifier1.complete(next);
        });
        mockedUDFThread1.complete(null);
        Assertions.assertThat(nextFinishIdentifier1).isNotCompleted();
        iterator.addRecord((Object)RECORD);
        nextFinishIdentifier1.get();
        Assertions.assertThat(nextFinishIdentifier1).isCompletedWithValue((Object)RECORD);
        CompletableFuture mockedUDFThread2 = new CompletableFuture();
        CompletableFuture nextFinishIdentifier2 = new CompletableFuture();
        mockedUDFThread2.thenRunAsync(() -> {
            String next = (String)iterator.next();
            nextFinishIdentifier2.complete(next);
            udfFinishTrigger.complete(null);
        });
        mockedUDFThread2.complete(null);
        Assertions.assertThat(nextFinishIdentifier2).isNotCompleted();
        iterator.close();
        Assertions.assertThat(nextFinishIdentifier2).isCompletedWithValue(null);
        Assertions.assertThat(udfFinishTrigger).isCompleted();
    }

    @Test
    void testClose() throws ExecutionException, InterruptedException {
        CompletableFuture<Object> udfFinishTrigger1 = new CompletableFuture<Object>();
        MapPartitionIterator iterator1 = new MapPartitionIterator(ignored -> {
            try {
                udfFinishTrigger1.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        });
        iterator1.addRecord((Object)RECORD);
        CompletableFuture mockedTaskThread1 = new CompletableFuture();
        CompletableFuture iteratorCloseIdentifier1 = new CompletableFuture();
        mockedTaskThread1.thenRunAsync(() -> {
            iterator1.close();
            iteratorCloseIdentifier1.complete(null);
        });
        mockedTaskThread1.complete(null);
        Assertions.assertThat(iteratorCloseIdentifier1).isNotCompleted();
        udfFinishTrigger1.complete(null);
        iteratorCloseIdentifier1.get();
        Assertions.assertThat(iteratorCloseIdentifier1).isCompleted();
        CompletableFuture<Object> udfFinishTrigger2 = new CompletableFuture<Object>();
        MapPartitionIterator iterator2 = new MapPartitionIterator(ignored -> {
            try {
                udfFinishTrigger2.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        });
        CompletableFuture<Object> mockedTaskThread2 = new CompletableFuture<Object>();
        CompletableFuture iteratorCloseIdentifier2 = new CompletableFuture();
        mockedTaskThread1.thenRunAsync(() -> {
            iterator2.close();
            iteratorCloseIdentifier2.complete(null);
        });
        mockedTaskThread2.complete(null);
        Assertions.assertThat(iteratorCloseIdentifier2).isNotCompleted();
        udfFinishTrigger2.complete(null);
        iteratorCloseIdentifier2.get();
        Assertions.assertThat(iteratorCloseIdentifier2).isCompleted();
        MapPartitionIterator iterator3 = new MapPartitionIterator(ignored -> {});
        iterator3.close();
    }

    private void addRecordToIterator(int cacheNumber, MapPartitionIterator<String> iterator) {
        for (int index = 0; index < cacheNumber; ++index) {
            iterator.addRecord((Object)RECORD);
        }
    }
}

