/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.functions.sink.filesystem.DefaultBucketFactoryImpl;
import org.apache.flink.streaming.api.functions.sink.filesystem.TestUtils;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class LocalStreamingFileSinkTest {
    @TempDir
    private static Path tempFolder;

    LocalStreamingFileSinkTest() {
    }

    @Test
    void testClosingWithoutInput() throws Exception {
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 124L);){
            testHarness.setup();
            testHarness.open();
        }
    }

    @Test
    void testClosingWithoutInitializingStateShouldNotFail() throws Exception {
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 124L);){
            testHarness.setup();
        }
    }

    @Test
    void testTruncateAfterRecoveryAndOverwrite() throws Exception {
        OperatorSubtaskState snapshot;
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 1, 0);
            snapshot = testHarness.snapshot(1L, 1L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)2), 2L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)3), 3L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            Map<File, String> contents = TestUtils.getFileContentByPath(outDir);
            int fileCounter = 0;
            for (Map.Entry<File, String> fileContents : contents.entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\ntest1@2\n");
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress")) continue;
                ++fileCounter;
                Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@3\n");
            }
            Assertions.assertThat((int)fileCounter).isEqualTo(2L);
        }
        testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);
        var4_3 = null;
        try {
            testHarness.setup();
            testHarness.initializeState(snapshot);
            testHarness.open();
            TestUtils.checkLocalFs(outDir, 2, 0);
            int fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\n");
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress")) continue;
                ++fileCounter;
                Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@3\n");
            }
            Assertions.assertThat((int)fileCounter).isEqualTo(2L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)4), 4L));
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\ntest1@4\n");
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress")) continue;
                ++fileCounter;
                Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@3\n");
            }
            Assertions.assertThat((int)fileCounter).isEqualTo(2L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)5), 5L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(2L, 2L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)6), 6L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\ntest1@4\n");
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress") || !fileContents.getValue().equals("test1@5\ntest1@6\n") && !fileContents.getValue().equals("test1@3\n")) continue;
                ++fileCounter;
            }
            Assertions.assertThat((int)fileCounter).isEqualTo(3L);
            testHarness.notifyOfCompletedCheckpoint(2L);
            TestUtils.checkLocalFs(outDir, 2, 1);
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().equals("part-0-0")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\ntest1@4\n");
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress") || !fileContents.getValue().equals("test1@5\ntest1@6\n") && !fileContents.getValue().equals("test1@3\n")) continue;
                ++fileCounter;
            }
            Assertions.assertThat((int)fileCounter).isEqualTo(3L);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (testHarness != null) {
                if (var4_3 != null) {
                    try {
                        testHarness.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    testHarness.close();
                }
            }
        }
    }

    @Test
    void testCommitStagedFilesInCorrectOrder() throws Exception {
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);){
            testHarness.setup();
            testHarness.open();
            testHarness.setProcessingTime(0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)2), 2L));
            TestUtils.checkLocalFs(outDir, 1, 0);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)3), 3L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.snapshot(1L, 1L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)4), 4L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)5), 5L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)6), 6L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(2L, 2L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)7), 7L));
            TestUtils.checkLocalFs(outDir, 4, 0);
            testHarness.setProcessingTime(101L);
            testHarness.snapshot(3L, 3L);
            testHarness.notifyOfCompletedCheckpoint(1L);
            TestUtils.checkLocalFs(outDir, 3, 1);
            int fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().equals("part-0-0")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\ntest1@2\n");
                    continue;
                }
                if (fileContents.getKey().getName().contains(".part-0-1.inprogress")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@3\ntest1@4\n");
                    continue;
                }
                if (fileContents.getKey().getName().contains(".part-0-2.inprogress")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@5\ntest1@6\n");
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-3.inprogress")) continue;
                ++fileCounter;
                Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@7\n");
            }
            Assertions.assertThat((int)fileCounter).isEqualTo(4L);
            testHarness.notifyOfCompletedCheckpoint(3L);
            TestUtils.checkLocalFs(outDir, 0, 4);
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().equals("part-0-0")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\ntest1@2\n");
                    continue;
                }
                if (fileContents.getKey().getName().equals("part-0-1")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@3\ntest1@4\n");
                    continue;
                }
                if (fileContents.getKey().getName().equals("part-0-2")) {
                    ++fileCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@5\ntest1@6\n");
                    continue;
                }
                if (!fileContents.getKey().getName().equals("part-0-3")) continue;
                ++fileCounter;
                Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@7\n");
            }
            Assertions.assertThat((int)fileCounter).isEqualTo(4L);
        }
    }

    @Test
    void testInactivityPeriodWithLateNotify() throws Exception {
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 124L);){
            testHarness.setup();
            testHarness.open();
            testHarness.setProcessingTime(0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test2", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            int bucketCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getParentFile().getName().equals("test1")) {
                    ++bucketCounter;
                    continue;
                }
                if (!fileContents.getKey().getParentFile().getName().equals("test2")) continue;
                ++bucketCounter;
            }
            Assertions.assertThat((int)bucketCounter).isEqualTo(2L);
            testHarness.setProcessingTime(101L);
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.snapshot(0L, 0L);
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test3", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test4", (Object)1), 1L));
            testHarness.setProcessingTime(202L);
            testHarness.snapshot(1L, 0L);
            TestUtils.checkLocalFs(outDir, 4, 0);
            testHarness.notifyOfCompletedCheckpoint(0L);
            TestUtils.checkLocalFs(outDir, 2, 2);
            bucketCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getParentFile().getName().equals("test1")) {
                    ++bucketCounter;
                    Assertions.assertThat((String)fileContents.getKey().getName()).isEqualTo("part-0-0");
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\n");
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test2")) {
                    ++bucketCounter;
                    Assertions.assertThat((String)fileContents.getKey().getName()).isEqualTo("part-0-1");
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test2@1\n");
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test3")) {
                    ++bucketCounter;
                    continue;
                }
                if (!fileContents.getKey().getParentFile().getName().equals("test4")) continue;
                ++bucketCounter;
            }
            Assertions.assertThat((int)bucketCounter).isEqualTo(4L);
            testHarness.notifyOfCompletedCheckpoint(1L);
            TestUtils.checkLocalFs(outDir, 0, 4);
            bucketCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getParentFile().getName().equals("test1")) {
                    ++bucketCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test1@1\n");
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test2")) {
                    ++bucketCounter;
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test2@1\n");
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test3")) {
                    ++bucketCounter;
                    Assertions.assertThat((String)fileContents.getKey().getName()).isEqualTo("part-0-2");
                    Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test3@1\n");
                    continue;
                }
                if (!fileContents.getKey().getParentFile().getName().equals("test4")) continue;
                ++bucketCounter;
                Assertions.assertThat((String)fileContents.getKey().getName()).isEqualTo("part-0-3");
                Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test4@1\n");
            }
            Assertions.assertThat((int)bucketCounter).isEqualTo(4L);
        }
    }

    @Test
    void testClosingOnSnapshot() throws Exception {
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 2L);){
            testHarness.setup();
            testHarness.open();
            testHarness.setProcessingTime(0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test2", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.setProcessingTime(101L);
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test3", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(0L, 1L);
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.notifyOfCompletedCheckpoint(0L);
            TestUtils.checkLocalFs(outDir, 0, 3);
            testHarness.snapshot(1L, 0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test4", (Object)10), 10L));
            TestUtils.checkLocalFs(outDir, 1, 3);
        }
        TestUtils.checkLocalFs(outDir, 1, 3);
    }

    @Test
    void testClosingWithCustomizedBucketer() throws Exception {
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        long partMaxSize = 2L;
        long inactivityInterval = 100L;
        DefaultRollingPolicy rollingPolicy = DefaultRollingPolicy.builder().withMaxPartSize(new MemorySize(2L)).withRolloverInterval(Duration.ofMillis(100L)).withInactivityInterval(Duration.ofMillis(100L)).build();
        OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createCustomizedRescalingTestSink(outDir, 1, 0, 100L, new TestUtils.TupleToIntegerBucketer(), new TestUtils.Tuple2Encoder(), rollingPolicy, new DefaultBucketFactoryImpl());
        Object object = null;
        try {
            testHarness.setup();
            testHarness.open();
            testHarness.setProcessingTime(0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test2", (Object)2), 1L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.setProcessingTime(101L);
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test3", (Object)3), 1L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(0L, 1L);
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.notifyOfCompletedCheckpoint(0L);
            TestUtils.checkLocalFs(outDir, 0, 3);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test4", (Object)4), 10L));
            TestUtils.checkLocalFs(outDir, 1, 3);
            testHarness.snapshot(1L, 0L);
            testHarness.notifyOfCompletedCheckpoint(1L);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (testHarness != null) {
                if (object != null) {
                    try {
                        testHarness.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    testHarness.close();
                }
            }
        }
        TestUtils.checkLocalFs(outDir, 0, 4);
        Map<File, String> contents = TestUtils.getFileContentByPath(outDir);
        for (Map.Entry entry : contents.entrySet()) {
            Integer bucketId = Integer.parseInt(((File)entry.getKey()).getParentFile().getName());
            Assertions.assertThat((Integer)bucketId).isBetween(Integer.valueOf(1), Integer.valueOf(4));
            Assertions.assertThat((String)((String)entry.getValue())).isEqualTo(String.format("test%d@%d\n", bucketId, bucketId));
        }
    }

    @Test
    void testScalingDownAndMergingOfStates() throws Exception {
        OperatorSubtaskState mergedSnapshot;
        File outDir = TempDirUtils.newFolder((Path)tempFolder);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness1 = TestUtils.createRescalingTestSink(outDir, 2, 0, 100L, 10L);
             OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness2 = TestUtils.createRescalingTestSink(outDir, 2, 1, 100L, 10L);){
            testHarness1.setup();
            testHarness1.open();
            testHarness2.setup();
            testHarness2.open();
            testHarness1.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)0), 0L));
            TestUtils.checkLocalFs(outDir, 1, 0);
            testHarness2.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness2.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test2", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            int counter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                String parentFilename = fileContents.getKey().getParentFile().getName();
                String inProgressFilename = fileContents.getKey().getName();
                if (parentFilename.equals("test1") && (inProgressFilename.contains(".part-0-0.inprogress") || inProgressFilename.contains(".part-1-0.inprogress"))) {
                    ++counter;
                    continue;
                }
                if (!parentFilename.equals("test2") || !inProgressFilename.contains(".part-1-1.inprogress")) continue;
                ++counter;
            }
            Assertions.assertThat((int)counter).isEqualTo(3L);
            mergedSnapshot = AbstractStreamOperatorTestHarness.repackageState(testHarness1.snapshot(1L, 0L), testHarness2.snapshot(1L, 0L));
        }
        OperatorSubtaskState initState = AbstractStreamOperatorTestHarness.repartitionOperatorState(mergedSnapshot, 10, 2, 1, 0);
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);){
            testHarness.setup();
            testHarness.initializeState(initState);
            testHarness.open();
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(2L, 2L);
            testHarness.notifyOfCompletedCheckpoint(2L);
            int counter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                String parentFilename = fileContents.getKey().getParentFile().getName();
                String filename = fileContents.getKey().getName();
                if (parentFilename.equals("test1")) {
                    if (!filename.contains("-0.inprogress") && !filename.endsWith("-0")) continue;
                    ++counter;
                    Assertions.assertThat((String)fileContents.getValue()).isIn(new Object[]{"test1@1\n", "test1@0\n"});
                    continue;
                }
                if (!parentFilename.equals("test2") || !filename.contains(".part-1-1.inprogress")) continue;
                ++counter;
                Assertions.assertThat((String)fileContents.getValue()).isEqualTo("test2@1\n");
            }
            Assertions.assertThat((int)counter).isEqualTo(3L);
        }
    }
}

