/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.api.functions.sink.PrintSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkContextUtil;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PrintSinkFunctionTest {
    private final PrintStream originalSystemOut = System.out;
    private final PrintStream originalSystemErr = System.err;
    private final ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream arrayErrorStream = new ByteArrayOutputStream();
    private final String line = System.lineSeparator();

    PrintSinkFunctionTest() {
    }

    @BeforeEach
    void setUp() {
        System.setOut(new PrintStream(this.arrayOutputStream));
        System.setErr(new PrintStream(this.arrayErrorStream));
    }

    @AfterEach
    void tearDown() {
        if (System.out != this.originalSystemOut) {
            System.out.close();
        }
        if (System.err != this.originalSystemErr) {
            System.err.close();
        }
        System.setOut(this.originalSystemOut);
        System.setErr(this.originalSystemErr);
    }

    @Test
    void testPrintSinkStdOut() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction();
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintSinkStdErr() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction(true);
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assertions.assertThat((Object)printSink).hasToString("Print to System.err");
        Assertions.assertThat((Object)this.arrayErrorStream).hasToString("hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintSinkWithPrefix() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction();
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 2, 1));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("2> hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintSinkWithIdentifierAndPrefix() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction("mySink", false);
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 2, 1));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("mySink:2> hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintSinkWithIdentifierButNoPrefix() throws Exception {
        PrintSinkFunction printSink = new PrintSinkFunction("mySink", false);
        printSink.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        printSink.open(DefaultOpenContext.INSTANCE);
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("mySink> hello world!" + this.line);
        printSink.close();
    }
}

