/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.ExecutionConfigTest;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamExecutionEnvironmentConfigurationTest {
    @Parameter
    private TestSpec spec;

    StreamExecutionEnvironmentConfigurationTest() {
    }

    @Parameters(name="{0}")
    private static Collection<TestSpec> specs() {
        return Arrays.asList(TestSpec.testValue(TimeCharacteristic.IngestionTime).whenSetFromFile("pipeline.time-characteristic", "IngestionTime").viaSetter(StreamExecutionEnvironment::setStreamTimeCharacteristic).getterVia(StreamExecutionEnvironment::getStreamTimeCharacteristic).nonDefaultValue(TimeCharacteristic.EventTime), TestSpec.testValue(60000L).whenSetFromFile("execution.buffer-timeout", "1 min").viaSetter(StreamExecutionEnvironment::setBufferTimeout).getterVia(StreamExecutionEnvironment::getBufferTimeout).nonDefaultValue(12000L), TestSpec.testValue(false).whenSetFromFile("pipeline.operator-chaining", "false").viaSetter((env, b) -> {
            if (b.booleanValue()) {
                throw new IllegalArgumentException("Cannot programmatically enable operator chaining");
            }
            env.disableOperatorChaining();
        }).getterVia(StreamExecutionEnvironment::isChainingEnabled).nonDefaultValue(false), TestSpec.testValue(ExecutionConfig.ClosureCleanerLevel.TOP_LEVEL).whenSetFromFile("pipeline.closure-cleaner-level", "TOP_LEVEL").viaSetter((env, v) -> env.getConfig().setClosureCleanerLevel(v)).getterVia(env -> env.getConfig().getClosureCleanerLevel()).nonDefaultValue(ExecutionConfig.ClosureCleanerLevel.NONE), TestSpec.testValue(12000L).whenSetFromFile("execution.checkpointing.timeout", "12 s").viaSetter((env, v) -> env.getCheckpointConfig().setCheckpointTimeout(v.longValue())).getterVia(env -> env.getCheckpointConfig().getCheckpointTimeout()).nonDefaultValue(100L));
    }

    @TestTemplate
    void testLoadingFromConfiguration() {
        StreamExecutionEnvironment configFromSetters = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamExecutionEnvironment configFromFile = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration configuration = new Configuration();
        configuration.setString(this.spec.key, this.spec.value);
        configFromFile.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        this.spec.setValue(configFromSetters);
        this.spec.assertEqual(configFromFile, configFromSetters);
    }

    @TestTemplate
    void testNotOverridingIfNotSet() {
        StreamExecutionEnvironment environment = StreamExecutionEnvironment.getExecutionEnvironment();
        this.spec.setNonDefaultValue(environment);
        Configuration configuration = new Configuration();
        environment.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        this.spec.assertEqualNonDefault(environment);
    }

    private static class TestSpec<T> {
        private String key;
        private String value;
        private final T objectValue;
        private T nonDefaultValue;
        private BiConsumer<StreamExecutionEnvironment, T> setter;
        private Function<StreamExecutionEnvironment, T> getter;

        private TestSpec(T value) {
            this.objectValue = value;
        }

        public static <T> TestSpec<T> testValue(T value) {
            return new TestSpec<T>(value);
        }

        public TestSpec<T> whenSetFromFile(String key, String value) {
            this.key = key;
            this.value = value;
            return this;
        }

        public TestSpec<T> viaSetter(BiConsumer<StreamExecutionEnvironment, T> setter) {
            this.setter = setter;
            return this;
        }

        public TestSpec<T> getterVia(Function<StreamExecutionEnvironment, T> getter) {
            this.getter = getter;
            return this;
        }

        public TestSpec<T> nonDefaultValue(T nonDefaultValue) {
            this.nonDefaultValue = nonDefaultValue;
            return this;
        }

        public void setValue(StreamExecutionEnvironment config) {
            this.setter.accept(config, (StreamExecutionEnvironment)this.objectValue);
        }

        public void setNonDefaultValue(StreamExecutionEnvironment config) {
            this.setter.accept(config, (StreamExecutionEnvironment)this.nonDefaultValue);
        }

        public void assertEqual(StreamExecutionEnvironment configFromFile, StreamExecutionEnvironment configFromSetters) {
            Assertions.assertThat(this.getter.apply(configFromFile)).isEqualTo(this.getter.apply(configFromSetters));
        }

        public void assertEqualNonDefault(StreamExecutionEnvironment configFromFile) {
            Assertions.assertThat(this.getter.apply(configFromFile)).isEqualTo(this.nonDefaultValue);
        }

        public String toString() {
            return "key='" + this.key + '\'';
        }
    }
}

