/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowStagger;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.util.StreamRecordMatchers;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TumblingProcessingTimeWindowsTest
extends TestLogger {
    @Test
    public void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)0L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(0L, 5000L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)4999L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(0L, 5000L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5000L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5000L, 10000L)));
    }

    @Test
    public void testWindowAssignmentWithStagger() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)0L), (WindowStagger)WindowStagger.NATURAL);
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)150L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(150L, 5150L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5049L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(150L, 5150L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5150L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5150L, 10150L)));
    }

    @Test
    public void testWindowAssignmentWithGlobalOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)100L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)100L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(100L, 5100L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5099L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(100L, 5100L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5100L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5100L, 10100L)));
    }

    @Test
    public void testWindowAssignmentWithNegativeGlobalOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)-100L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)100L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(-100L, 4900L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)4899L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(-100L, 4900L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)4900L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(4900L, 9900L)));
    }

    @Test
    public void testTimeUnits() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.seconds((long)1L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)1000L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(1000L, 6000L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5999L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(1000L, 6000L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)6000L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(6000L, 11000L)));
    }

    @Test
    public void testInvalidParameters() {
        try {
            TumblingProcessingTimeWindows.of((Time)Time.seconds((long)-1L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < size"));
        }
        try {
            TumblingProcessingTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)20L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < size"));
        }
        try {
            TumblingProcessingTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)-11L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < size"));
        }
    }

    @Test
    public void testProperties() {
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.milliseconds((long)100L));
        Assert.assertFalse((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertThat((Object)assigner.getDefaultTrigger(), (Matcher)Matchers.instanceOf(ProcessingTimeTrigger.class));
    }
}

