/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.operators.collect.utils.AbstractTestCoordinationRequestHandler;

public class TestCheckpointedCoordinationRequestHandler<T>
extends AbstractTestCoordinationRequestHandler<T> {
    private int checkpointCountDown = 0;
    private LinkedList<T> data;
    private List<T> checkpointingData;
    private List<T> checkpointedData;
    private List<T> checkpointingBuffered;
    private List<T> checkpointedBuffered;
    private long checkpointingOffset;

    public TestCheckpointedCoordinationRequestHandler(List<T> data, TypeSerializer<T> serializer, String accumulatorName) {
        super(serializer, accumulatorName);
        this.data = new LinkedList<T>(data);
        this.checkpointedData = new ArrayList<T>(data);
        this.checkpointedBuffered = new ArrayList<T>();
        this.checkpointingOffset = 0L;
    }

    @Override
    protected void updateBufferedResults() {
        for (int i = this.random.nextInt(3) + 1; i > 0; --i) {
            int r;
            if (this.checkpointCountDown > 0) {
                --this.checkpointCountDown;
                if (this.checkpointCountDown == 0) {
                    this.checkpointedData = this.checkpointingData;
                    this.checkpointedBuffered = this.checkpointingBuffered;
                    this.checkpointedOffset = this.checkpointingOffset;
                }
            }
            if ((r = this.random.nextInt(10)) < 6) {
                int size = Math.min(this.data.size(), 6 - this.buffered.size());
                if (size > 0) {
                    size = this.random.nextInt(size) + 1;
                }
                for (int j = 0; j < size; ++j) {
                    this.buffered.add(this.data.removeFirst());
                }
                if (!this.data.isEmpty()) continue;
                this.buildAccumulatorResults();
                this.closed = true;
                break;
            }
            if (r < 9) {
                if (this.checkpointCountDown != 0) continue;
                this.checkpointCountDown = this.random.nextInt(5) + 1;
                this.checkpointingData = new ArrayList<T>(this.data);
                this.checkpointingBuffered = new ArrayList<T>(this.buffered);
                this.checkpointingOffset = this.offset;
                continue;
            }
            this.checkpointCountDown = 0;
            this.version = UUID.randomUUID().toString();
            Collections.shuffle(this.checkpointedData);
            this.data = new LinkedList<T>(this.checkpointedData);
            this.buffered = new LinkedList<T>(this.checkpointedBuffered);
            this.offset = this.checkpointedOffset;
        }
    }
}

