/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeoutTrigger;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;

public class ProcessingTimeoutTriggerTest {
    @Test
    public void testWindowFireWithoutResetTimer() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)true), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(-9223372036854775768L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceProcessingTime(-9223372036854775758L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
    }

    @Test
    public void testWindowFireWithResetTimer() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)true, (boolean)true), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(0L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(10L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(50L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceProcessingTime(60L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1, 0L), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1, 10L), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.processElement(new StreamRecord((Object)1, 20L), new TimeWindow(0L, 2L)));
    }

    @Test
    public void testWindowFireWithoutClearOnTimeout() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)false), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceProcessingTime(-9223372036854775758L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testWindowPurgingWhenInnerTriggerIsPurging() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeoutTrigger.of((Trigger)PurgingTrigger.of((Trigger)ProcessingTimeTrigger.create()), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)false), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)2L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)testHarness.advanceProcessingTime(-9223372036854775758L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)1L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }
}

