/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.LinkedList;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.StreamTestSingleInputGate;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.AbstractTwoInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskTestHarness;
import org.apache.flink.util.function.FunctionWithException;

@Deprecated
public class TwoInputStreamTaskTestHarness<IN1, IN2, OUT>
extends StreamTaskTestHarness<OUT> {
    private TypeSerializer<IN1> inputSerializer1;
    private TypeSerializer<IN2> inputSerializer2;
    private int[] inputGateAssignment;

    public TwoInputStreamTaskTestHarness(FunctionWithException<Environment, ? extends AbstractTwoInputStreamTask<IN1, IN2, OUT>, Exception> taskFactory, int numInputGates, int numInputChannelsPerGate, int[] inputGateAssignment, TypeInformation<IN1> inputType1, TypeInformation<IN2> inputType2, TypeInformation<OUT> outputType) {
        super(taskFactory, outputType);
        this.inputSerializer1 = inputType1.createSerializer(this.executionConfig.getSerializerConfig());
        this.inputSerializer2 = inputType2.createSerializer(this.executionConfig.getSerializerConfig());
        this.numInputGates = numInputGates;
        this.numInputChannelsPerGate = numInputChannelsPerGate;
        this.inputGateAssignment = inputGateAssignment;
    }

    public TwoInputStreamTaskTestHarness(FunctionWithException<Environment, ? extends AbstractTwoInputStreamTask<IN1, IN2, OUT>, Exception> taskFactory, TypeInformation<IN1> inputType1, TypeInformation<IN2> inputType2, TypeInformation<OUT> outputType) {
        this(taskFactory, 2, 1, new int[]{1, 2}, inputType1, inputType2, outputType);
    }

    @Override
    protected void initializeInputs() {
        this.inputGates = new StreamTestSingleInputGate[this.numInputGates];
        LinkedList<StreamEdge> inPhysicalEdges = new LinkedList<StreamEdge>();
        AbstractStreamOperator dummyOperator = new AbstractStreamOperator<IN1>(){
            private static final long serialVersionUID = 1L;
        };
        StreamNode sourceVertexDummy = new StreamNode(Integer.valueOf(0), "default group", null, (StreamOperator)dummyOperator, "source dummy", SourceStreamTask.class);
        StreamNode targetVertexDummy = new StreamNode(Integer.valueOf(1), "default group", null, (StreamOperator)dummyOperator, "target dummy", SourceStreamTask.class);
        for (int i = 0; i < this.numInputGates; ++i) {
            switch (this.inputGateAssignment[i]) {
                case 1: {
                    this.inputGates[i] = new StreamTestSingleInputGate<IN1>(this.numInputChannelsPerGate, i, this.inputSerializer1, this.bufferSize);
                    StreamEdge streamEdge = new StreamEdge(sourceVertexDummy, targetVertexDummy, 1, (StreamPartitioner)new BroadcastPartitioner(), null);
                    inPhysicalEdges.add(streamEdge);
                    break;
                }
                case 2: {
                    this.inputGates[i] = new StreamTestSingleInputGate<IN2>(this.numInputChannelsPerGate, i, this.inputSerializer2, this.bufferSize);
                    StreamEdge streamEdge = new StreamEdge(sourceVertexDummy, targetVertexDummy, 2, (StreamPartitioner)new BroadcastPartitioner(), null);
                    inPhysicalEdges.add(streamEdge);
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong input gate assignment.");
                }
            }
            this.mockEnv.addInputGate((IndexedInputGate)this.inputGates[i].getInputGate());
        }
        this.streamConfig.setInPhysicalEdges(inPhysicalEdges);
        this.streamConfig.setNumberOfNetworkInputs(this.numInputGates);
        this.streamConfig.setupNetworkInputs(new TypeSerializer[]{this.inputSerializer1, this.inputSerializer2});
    }

    public AbstractTwoInputStreamTask<IN1, IN2, OUT> getTask() {
        return (AbstractTwoInputStreamTask)super.getTask();
    }
}

