/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.graph;

import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.junit.Assert;
import org.junit.Test;

public class TranslationTest {
    @Test
    public void testCheckpointModeTranslation() {
        try {
            StreamExecutionEnvironment deactivated = TranslationTest.getSimpleJob();
            for (Object vertex : deactivated.getStreamGraph().getJobGraph().getVertices()) {
                Assert.assertEquals((Object)CheckpointingMode.AT_LEAST_ONCE, (Object)new StreamConfig(vertex.getConfiguration()).getCheckpointMode());
            }
            StreamExecutionEnvironment activated = TranslationTest.getSimpleJob();
            activated.enableCheckpointing(1000L);
            for (JobVertex vertex : activated.getStreamGraph().getJobGraph().getVertices()) {
                Assert.assertEquals((Object)CheckpointingMode.EXACTLY_ONCE, (Object)new StreamConfig(vertex.getConfiguration()).getCheckpointMode());
            }
            StreamExecutionEnvironment explicit = TranslationTest.getSimpleJob();
            explicit.enableCheckpointing(1000L, CheckpointingMode.AT_LEAST_ONCE);
            for (JobVertex vertex : explicit.getStreamGraph().getJobGraph().getVertices()) {
                Assert.assertEquals((Object)CheckpointingMode.AT_LEAST_ONCE, (Object)new StreamConfig(vertex.getConfiguration()).getCheckpointMode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static StreamExecutionEnvironment getSimpleJob() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromSequence(1L, 10000000L).addSink((SinkFunction)new SinkFunction<Long>(){

            public void invoke(Long value) {
            }
        });
        return env;
    }
}

