/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.datastream.CustomSinkOperatorUidHashes;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.SinkTransformationTranslatorITCaseBase;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.runtime.operators.sink.TestSinkV2;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SinkV2TransformationTranslatorITCase
extends SinkTransformationTranslatorITCaseBase<Sink<Integer>> {
    @Override
    Sink<Integer> simpleSink() {
        return TestSinkV2.newBuilder().build();
    }

    @Override
    Sink<Integer> sinkWithCommitter() {
        return TestSinkV2.newBuilder().setDefaultCommitter().build();
    }

    @Override
    DataStreamSink<Integer> sinkTo(DataStream<Integer> stream, Sink<Integer> sink) {
        return stream.sinkTo(sink);
    }

    @Test
    public void testSettingOperatorUidHash() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        String writerHash = "f6b178ce445dc3ffaa06bad27a51fead";
        String committerHash = "68ac8ae79eae4e3135a54f9689c4aa10";
        CustomSinkOperatorUidHashes operatorsUidHashes = CustomSinkOperatorUidHashes.builder().setWriterUidHash("f6b178ce445dc3ffaa06bad27a51fead").setCommitterUidHash("68ac8ae79eae4e3135a54f9689c4aa10").build();
        src.sinkTo(this.sinkWithCommitter(), operatorsUidHashes).name("FileSink");
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((Object)this.findWriter(streamGraph).getUserHash(), (Object)"f6b178ce445dc3ffaa06bad27a51fead");
        Assert.assertEquals((Object)this.findCommitter(streamGraph).getUserHash(), (Object)"68ac8ae79eae4e3135a54f9689c4aa10");
    }

    @Test
    public void testSettingOperatorUids() {
        String sinkUid = "f6b178ce445dc3ffaa06bad27a51fead";
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        src.sinkTo(this.sinkWithCommitter()).name("FileSink").uid("f6b178ce445dc3ffaa06bad27a51fead");
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((Object)this.findWriter(streamGraph).getTransformationUID(), (Object)"f6b178ce445dc3ffaa06bad27a51fead");
        Assert.assertEquals((Object)this.findCommitter(streamGraph).getTransformationUID(), (Object)String.format("Sink Committer: %s", "f6b178ce445dc3ffaa06bad27a51fead"));
    }
}

