/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import javax.annotation.Nullable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.RecordProcessorUtils;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.streaming.runtime.tasks.WatermarkGaugeExposingOutput;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChainingOutput<T>
implements WatermarkGaugeExposingOutput<StreamRecord<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainingOutput.class);
    protected final Input<T> input;
    protected final Counter numRecordsOut;
    protected final Counter numRecordsIn;
    protected final WatermarkGauge watermarkGauge = new WatermarkGauge();
    @Nullable
    protected final OutputTag<T> outputTag;
    protected WatermarkStatus announcedStatus = WatermarkStatus.ACTIVE;
    protected final ThrowingConsumer<StreamRecord<T>, Exception> recordProcessor;

    public ChainingOutput(Input<T> input, @Nullable Counter prevNumRecordsOut, OperatorMetricGroup curOperatorMetricGroup, @Nullable OutputTag<T> outputTag) {
        this.input = input;
        this.numRecordsOut = prevNumRecordsOut != null ? prevNumRecordsOut : new SimpleCounter();
        this.numRecordsIn = curOperatorMetricGroup.getIOMetricGroup().getNumRecordsInCounter();
        this.outputTag = outputTag;
        this.recordProcessor = RecordProcessorUtils.getRecordProcessor(input);
    }

    public void collect(StreamRecord<T> record) {
        if (this.outputTag != null) {
            return;
        }
        this.pushToOperator(record);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        if (OutputTag.isResponsibleFor(this.outputTag, outputTag)) {
            this.pushToOperator(record);
        }
    }

    protected <X> void pushToOperator(StreamRecord<X> record) {
        try {
            StreamRecord<X> castRecord = record;
            this.numRecordsOut.inc();
            this.numRecordsIn.inc();
            this.recordProcessor.accept(castRecord);
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void emitWatermark(Watermark mark) {
        if (this.announcedStatus.isIdle()) {
            return;
        }
        try {
            this.watermarkGauge.setCurrentWatermark(mark.getTimestamp());
            this.input.processWatermark(mark);
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        try {
            this.input.processLatencyMarker(latencyMarker);
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Gauge<Long> getWatermarkGauge() {
        return this.watermarkGauge;
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        if (!this.announcedStatus.equals(watermarkStatus)) {
            this.announcedStatus = watermarkStatus;
            try {
                this.input.processWatermarkStatus(watermarkStatus);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }
    }
}

