/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.state.BroadcastState;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.streaming.api.functions.sink.filesystem.TestUtils;

public class MockOperatorStateStore
implements OperatorStateStore {
    private final Map<Long, Map<String, TestUtils.MockListState>> historyStateMap = new HashMap<Long, Map<String, TestUtils.MockListState>>();
    private Map<String, TestUtils.MockListState> currentStateMap = new HashMap<String, TestUtils.MockListState>();
    private Map<String, TestUtils.MockListState> lastSuccessStateMap = new HashMap<String, TestUtils.MockListState>();

    public <K, V> BroadcastState<K, V> getBroadcastState(MapStateDescriptor<K, V> stateDescriptor) throws Exception {
        return null;
    }

    public <S> ListState<S> getListState(ListStateDescriptor<S> stateDescriptor) throws Exception {
        String name = stateDescriptor.getName();
        this.currentStateMap.putIfAbsent(name, new TestUtils.MockListState());
        return this.currentStateMap.get(name);
    }

    public <S> ListState<S> getUnionListState(ListStateDescriptor<S> stateDescriptor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Set<String> getRegisteredStateNames() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getRegisteredBroadcastStateNames() {
        throw new UnsupportedOperationException();
    }

    public void checkpointBegin(long checkpointId) {
        Map<String, TestUtils.MockListState> copiedStates = Collections.unmodifiableMap(this.copyStates(this.currentStateMap));
        this.historyStateMap.put(checkpointId, copiedStates);
    }

    public void checkpointSuccess(long checkpointId) {
        this.lastSuccessStateMap = this.historyStateMap.get(checkpointId);
    }

    public void revertToLastSuccessCheckpoint() {
        this.currentStateMap = this.copyStates(this.lastSuccessStateMap);
    }

    private Map<String, TestUtils.MockListState> copyStates(Map<String, TestUtils.MockListState> stateMap) {
        HashMap<String, TestUtils.MockListState> copiedStates = new HashMap<String, TestUtils.MockListState>();
        for (Map.Entry<String, TestUtils.MockListState> entry : stateMap.entrySet()) {
            TestUtils.MockListState copiedState = new TestUtils.MockListState();
            copiedState.addAll(entry.getValue().getBackingList());
            copiedStates.put(entry.getKey(), copiedState);
        }
        return copiedStates;
    }
}

