/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.PojoComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import scala.Product;

public abstract class FieldAccessor<R, F>
implements Serializable {
    private static final long serialVersionUID = 1L;
    TypeInformation fieldType;

    public TypeInformation<F> getFieldType() {
        return this.fieldType;
    }

    public abstract F get(R var1);

    public abstract R set(R var1, F var2);

    public static <R, F> FieldAccessor<R, F> create(int pos, TypeInformation<R> typeInfo, ExecutionConfig config) {
        if (typeInfo.isTupleType() && ((TupleTypeInfoBase)typeInfo).isCaseClass()) {
            return new ProductFieldAccessor(pos, typeInfo, config);
        }
        if (typeInfo.isTupleType()) {
            return new TupleFieldAccessor(pos, typeInfo);
        }
        if (typeInfo instanceof BasicArrayTypeInfo || typeInfo instanceof PrimitiveArrayTypeInfo) {
            return new ArrayFieldAccessor(pos, typeInfo);
        }
        if (pos != 0) {
            throw new IndexOutOfBoundsException("Not 0th field selected for a simple type (non-tuple, non-array).");
        }
        return new SimpleFieldAccessor<R>(typeInfo);
    }

    public static <R, F> FieldAccessor<R, F> create(String field, TypeInformation<R> typeInfo, ExecutionConfig config) {
        if (typeInfo.isTupleType() && ((TupleTypeInfoBase)typeInfo).isCaseClass()) {
            int pos = ((TupleTypeInfoBase)typeInfo).getFieldIndex(field);
            if (pos == -2) {
                throw new RuntimeException("Invalid field selected: " + field);
            }
            return new ProductFieldAccessor(pos, typeInfo, config);
        }
        if (typeInfo.isTupleType()) {
            return new TupleFieldAccessor(((TupleTypeInfo)typeInfo).getFieldIndex(field), typeInfo);
        }
        return new PojoFieldAccessor(field, typeInfo, config);
    }

    public static class ProductFieldAccessor<R, F>
    extends FieldAccessor<R, F> {
        private static final long serialVersionUID = 1L;
        int pos;
        TupleSerializerBase<R> serializer;
        Object[] fields;
        int length;

        ProductFieldAccessor(int pos, TypeInformation<R> typeInfo, ExecutionConfig config) {
            this.pos = pos;
            this.fieldType = ((TupleTypeInfoBase)typeInfo).getTypeAt(pos);
            this.serializer = (TupleSerializerBase)typeInfo.createSerializer(config);
            this.length = this.serializer.getArity();
            this.fields = new Object[this.length];
        }

        @Override
        public F get(R record) {
            return (F)((Product)record).productElement(this.pos);
        }

        @Override
        public R set(R record, F fieldValue) {
            Product prod = (Product)record;
            for (int i = 0; i < this.length; ++i) {
                this.fields[i] = prod.productElement(i);
            }
            this.fields[this.pos] = fieldValue;
            return (R)this.serializer.createInstance(this.fields);
        }
    }

    public static class PojoFieldAccessor<R, F>
    extends FieldAccessor<R, F> {
        private static final long serialVersionUID = 1L;
        PojoComparator comparator;

        PojoFieldAccessor(String field, TypeInformation<R> type, ExecutionConfig config) {
            if (!(type instanceof CompositeType)) {
                throw new IllegalArgumentException("Key expressions are only supported on POJO types and Tuples. A type is considered a POJO if all its fields are public, or have both getters and setters defined");
            }
            CompositeType cType = (CompositeType)type;
            List fieldDescriptors = cType.getFlatFields(field);
            int logicalKeyPosition = ((CompositeType.FlatFieldDescriptor)fieldDescriptors.get(0)).getPosition();
            this.fieldType = ((CompositeType.FlatFieldDescriptor)fieldDescriptors.get(0)).getType();
            Class keyClass = this.fieldType.getTypeClass();
            if (!(cType instanceof PojoTypeInfo)) {
                throw new IllegalArgumentException("Key expressions are only supported on POJO types. A type is considered a POJO if all its fields are public, or have both getters and setters defined");
            }
            this.comparator = (PojoComparator)cType.createComparator(new int[]{logicalKeyPosition}, new boolean[]{false}, 0, config);
        }

        @Override
        public F get(R record) {
            return (F)this.comparator.accessField(this.comparator.getKeyFields()[0], record);
        }

        @Override
        public R set(R record, F fieldValue) {
            try {
                this.comparator.getKeyFields()[0].set(record, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not modify the specified field.", e);
            }
            return record;
        }
    }

    public static class TupleFieldAccessor<R, F>
    extends FieldAccessor<R, F> {
        private static final long serialVersionUID = 1L;
        int pos;

        TupleFieldAccessor(int pos, TypeInformation<R> typeInfo) {
            this.pos = pos;
            this.fieldType = ((TupleTypeInfo)typeInfo).getTypeAt(pos);
        }

        @Override
        public F get(R record) {
            Tuple tuple = (Tuple)record;
            return (F)tuple.getField(this.pos);
        }

        @Override
        public R set(R record, F fieldValue) {
            Tuple tuple = (Tuple)record;
            tuple.setField(fieldValue, this.pos);
            return record;
        }
    }

    public static class ArrayFieldAccessor<R, F>
    extends FieldAccessor<R, F> {
        private static final long serialVersionUID = 1L;
        int pos;

        ArrayFieldAccessor(int pos, TypeInformation typeInfo) {
            this.pos = pos;
            this.fieldType = BasicTypeInfo.getInfoFor(typeInfo.getTypeClass().getComponentType());
        }

        @Override
        public F get(R record) {
            return (F)Array.get(record, this.pos);
        }

        @Override
        public R set(R record, F fieldValue) {
            Array.set(record, this.pos, fieldValue);
            return record;
        }
    }

    public static class SimpleFieldAccessor<R>
    extends FieldAccessor<R, R> {
        private static final long serialVersionUID = 1L;

        SimpleFieldAccessor(TypeInformation<R> typeInfo) {
            this.fieldType = typeInfo;
        }

        @Override
        public R get(R record) {
            return record;
        }

        @Override
        public R set(R record, R fieldValue) {
            return fieldValue;
        }
    }
}

