/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.windows;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.windowing.windows.Window;

public class TimeWindow
extends Window {
    private final long start;
    private final long end;

    public TimeWindow(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public long maxTimestamp() {
        return this.end - 1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindow window = (TimeWindow)o;
        return this.end == window.end && this.start == window.start;
    }

    public int hashCode() {
        int result = (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        return result;
    }

    public String toString() {
        return "TimeWindow{start=" + this.start + ", end=" + this.end + '}';
    }

    public static class Serializer
    extends TypeSerializer<TimeWindow> {
        private static final long serialVersionUID = 1L;

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<TimeWindow> duplicate() {
            return this;
        }

        public TimeWindow createInstance() {
            return null;
        }

        public TimeWindow copy(TimeWindow from) {
            return from;
        }

        public TimeWindow copy(TimeWindow from, TimeWindow reuse) {
            return from;
        }

        public int getLength() {
            return 0;
        }

        public void serialize(TimeWindow record, DataOutputView target) throws IOException {
            target.writeLong(record.start);
            target.writeLong(record.end);
        }

        public TimeWindow deserialize(DataInputView source) throws IOException {
            long start = source.readLong();
            long end = source.readLong();
            return new TimeWindow(start, end);
        }

        public TimeWindow deserialize(TimeWindow reuse, DataInputView source) throws IOException {
            long start = source.readLong();
            long end = source.readLong();
            return new TimeWindow(start, end);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeLong(source.readLong());
            target.writeLong(source.readLong());
        }

        public boolean equals(Object obj) {
            return obj instanceof Serializer;
        }

        public boolean canEqual(Object obj) {
            return obj instanceof Serializer;
        }

        public int hashCode() {
            return 0;
        }
    }
}

