/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.StreamTransformation;

public class UnionTransformation<T>
extends StreamTransformation<T> {
    private final List<StreamTransformation<T>> inputs;

    public UnionTransformation(List<StreamTransformation<T>> inputs) {
        super("Union", inputs.get(0).getOutputType(), inputs.get(0).getParallelism());
        for (StreamTransformation<T> input : inputs) {
            if (input.getOutputType().equals(this.getOutputType())) continue;
            throw new UnsupportedOperationException("Type mismatch in input " + input);
        }
        this.inputs = Lists.newArrayList(inputs);
    }

    public List<StreamTransformation<T>> getInputs() {
        return this.inputs;
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        ArrayList<StreamTransformation<?>> result = Lists.newArrayList();
        result.add(this);
        for (StreamTransformation<T> input : this.inputs) {
            result.addAll(input.getTransitivePredecessors());
        }
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        throw new UnsupportedOperationException("Cannot set chaining strategy on Union Transformation.");
    }
}

