/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class CoStreamMap<IN1, IN2, OUT>
extends AbstractUdfStreamOperator<OUT, CoMapFunction<IN1, IN2, OUT>>
implements TwoInputStreamOperator<IN1, IN2, OUT> {
    private static final long serialVersionUID = 1L;
    private long combinedWatermark = Long.MIN_VALUE;
    private long input1Watermark = Long.MIN_VALUE;
    private long input2Watermark = Long.MIN_VALUE;

    public CoStreamMap(CoMapFunction<IN1, IN2, OUT> mapper) {
        super(mapper);
    }

    @Override
    public void processElement1(StreamRecord<IN1> element) throws Exception {
        this.output.collect(element.replace(((CoMapFunction)this.userFunction).map1(element.getValue())));
    }

    @Override
    public void processElement2(StreamRecord<IN2> element) throws Exception {
        this.output.collect(element.replace(((CoMapFunction)this.userFunction).map2(element.getValue())));
    }

    @Override
    public void processWatermark1(Watermark mark) throws Exception {
        this.input1Watermark = mark.getTimestamp();
        long newMin = Math.min(this.input1Watermark, this.input2Watermark);
        if (newMin > this.combinedWatermark) {
            this.combinedWatermark = newMin;
            this.output.emitWatermark(new Watermark(this.combinedWatermark));
        }
    }

    @Override
    public void processWatermark2(Watermark mark) throws Exception {
        this.input2Watermark = mark.getTimestamp();
        long newMin = Math.min(this.input1Watermark, this.input2Watermark);
        if (newMin > this.combinedWatermark) {
            this.combinedWatermark = newMin;
            this.output.emitWatermark(new Watermark(this.combinedWatermark));
        }
    }
}

