/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.AbstractRuntimeUDFContext;
import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.runtime.operators.Triggerable;

public class StreamingRuntimeContext
extends AbstractRuntimeUDFContext {
    private final AbstractStreamOperator<?> operator;
    private final Environment taskEnvironment;
    private HashMap<String, OperatorState<?>> keyValueStates;
    private HashMap<String, TypeInformation<?>> stateTypeInfos;
    private final StreamConfig streamConfig;

    public StreamingRuntimeContext(AbstractStreamOperator<?> operator, Environment env, Map<String, Accumulator<?, ?>> accumulators) {
        super(env.getTaskName(), env.getNumberOfSubtasks(), env.getIndexInSubtaskGroup(), env.getUserClassLoader(), operator.getExecutionConfig(), accumulators, env.getDistributedCacheEntries());
        this.operator = operator;
        this.taskEnvironment = env;
        this.streamConfig = new StreamConfig(env.getTaskConfiguration());
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.taskEnvironment.getInputSplitProvider();
    }

    public void registerTimer(long time, Triggerable target) {
        this.operator.registerTimer(time, target);
    }

    public <RT> List<RT> getBroadcastVariable(String name) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <S> OperatorState<S> getKeyValueState(String name, Class<S> stateType, S defaultState) {
        TypeInformation typeInfo;
        Objects.requireNonNull(stateType, "The state type class must not be null");
        try {
            typeInfo = TypeExtractor.getForClass(stateType);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot analyze type '" + stateType.getName() + "' from the class alone, due to generic type parameters. " + "Please specify the TypeInformation directly.", e);
        }
        return this.getKeyValueState(name, typeInfo, defaultState);
    }

    public <S> OperatorState<S> getKeyValueState(String name, TypeInformation<S> stateType, S defaultState) {
        OperatorState<?> previousState;
        Objects.requireNonNull(name, "The name of the state must not be null");
        Objects.requireNonNull(stateType, "The state type information must not be null");
        if (this.stateTypeInfos != null && this.keyValueStates != null && (previousState = this.keyValueStates.get(name)) != null) {
            TypeInformation<?> previousType = this.stateTypeInfos.get(name);
            if (stateType.equals(previousType)) {
                OperatorState<?> previous = previousState;
                return previous;
            }
            throw new IllegalStateException("Cannot initialize key/value state for type " + stateType + " ; The key/value state has already been created and initialized for a different type: " + previousType);
        }
        if (this.stateTypeInfos == null) {
            this.stateTypeInfos = new HashMap();
        }
        if (this.keyValueStates == null) {
            this.keyValueStates = new HashMap();
        }
        try {
            OperatorState<S> state = this.operator.createKeyValueState(name, stateType, defaultState);
            this.keyValueStates.put(name, state);
            this.stateTypeInfos.put(name, stateType);
            return state;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize the key/value state", e);
        }
    }

    public boolean isCheckpointingEnabled() {
        return this.streamConfig.isCheckpointingEnabled();
    }

    public CheckpointingMode getCheckpointMode() {
        return this.streamConfig.getCheckpointMode();
    }

    public long getBufferTimeout() {
        return this.streamConfig.getBufferTimeout();
    }
}

