/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.WriteFormat;

public abstract class WriteSinkFunction<IN>
implements SinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    protected final String path;
    protected ArrayList<IN> tupleList = new ArrayList();
    protected WriteFormat<IN> format;

    public WriteSinkFunction(String path, WriteFormat<IN> format) {
        this.path = path;
        this.format = format;
        this.cleanFile(path);
    }

    protected void cleanFile(String path) {
        try {
            PrintWriter writer = new PrintWriter(path);
            writer.print("");
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("An error occurred while cleaning the file: " + e.getMessage(), e);
        }
    }

    protected abstract boolean updateCondition();

    protected abstract void resetParameters();

    @Override
    public void invoke(IN tuple) {
        this.tupleList.add(tuple);
        if (this.updateCondition()) {
            this.format.write(this.path, this.tupleList);
            this.resetParameters();
        }
    }
}

