/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.CleanupWhenUnsuccessful;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileSinkFunction<IN>
extends RichSinkFunction<IN>
implements InputTypeConfigurable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FileSinkFunction.class);
    protected ArrayList<IN> tupleList = new ArrayList();
    protected volatile OutputFormat<IN> format;
    protected volatile boolean cleanupCalled = false;
    protected int indexInSubtaskGroup;
    protected int currentNumberOfSubtasks;

    public FileSinkFunction(OutputFormat<IN> format) {
        this.format = format;
    }

    public void open(Configuration parameters) throws Exception {
        RuntimeContext context = this.getRuntimeContext();
        this.format.configure(parameters);
        this.indexInSubtaskGroup = context.getIndexOfThisSubtask();
        this.currentNumberOfSubtasks = context.getNumberOfParallelSubtasks();
        this.format.open(this.indexInSubtaskGroup, this.currentNumberOfSubtasks);
    }

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        if (this.format instanceof InputTypeConfigurable) {
            InputTypeConfigurable itc = (InputTypeConfigurable)this.format;
            itc.setInputType(type, executionConfig);
        }
    }

    @Override
    public void invoke(IN record) throws Exception {
        this.tupleList.add(record);
        if (this.updateCondition()) {
            this.flush();
        }
    }

    public void close() throws IOException {
        if (!this.tupleList.isEmpty()) {
            this.flush();
        }
        try {
            this.format.close();
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error while writing element.", (Throwable)ex);
            }
            try {
                if (!this.cleanupCalled && this.format instanceof CleanupWhenUnsuccessful) {
                    this.cleanupCalled = true;
                    ((CleanupWhenUnsuccessful)this.format).tryCleanupOnError();
                }
            }
            catch (Throwable t) {
                LOG.error("Cleanup on error failed.", t);
            }
        }
    }

    protected void flush() {
        try {
            for (IN rec : this.tupleList) {
                this.format.writeRecord(rec);
            }
        }
        catch (Exception ex) {
            try {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error while writing element.", (Throwable)ex);
                }
                if (!this.cleanupCalled && this.format instanceof CleanupWhenUnsuccessful) {
                    this.cleanupCalled = true;
                    ((CleanupWhenUnsuccessful)this.format).tryCleanupOnError();
                }
            }
            catch (Throwable t) {
                LOG.error("Cleanup on error failed.", t);
            }
            throw new RuntimeException(ex);
        }
        this.resetParameters();
    }

    protected abstract boolean updateCondition();

    protected abstract void resetParameters();
}

