/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;

public class SingleOutputStreamOperator<T, O extends SingleOutputStreamOperator<T, O>>
extends DataStream<T> {
    protected SingleOutputStreamOperator(StreamExecutionEnvironment environment, StreamTransformation<T> transformation) {
        super(environment, transformation);
    }

    public String getName() {
        return this.transformation.getName();
    }

    public SingleOutputStreamOperator<T, O> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    public SingleOutputStreamOperator<T, O> setParallelism(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("The parallelism of an operator must be at least 1.");
        }
        this.transformation.setParallelism(parallelism);
        return this;
    }

    public SingleOutputStreamOperator<T, O> setBufferTimeout(long timeoutMillis) {
        this.transformation.setBufferTimeout(timeoutMillis);
        return this;
    }

    public SingleOutputStreamOperator<T, O> broadcast() {
        return (SingleOutputStreamOperator)super.broadcast();
    }

    public SingleOutputStreamOperator<T, O> shuffle() {
        return (SingleOutputStreamOperator)super.shuffle();
    }

    public SingleOutputStreamOperator<T, O> forward() {
        return (SingleOutputStreamOperator)super.forward();
    }

    public SingleOutputStreamOperator<T, O> rebalance() {
        return (SingleOutputStreamOperator)super.rebalance();
    }

    public SingleOutputStreamOperator<T, O> global() {
        return (SingleOutputStreamOperator)super.global();
    }

    private SingleOutputStreamOperator<T, O> setChainingStrategy(ChainingStrategy strategy) {
        this.transformation.setChainingStrategy(strategy);
        return this;
    }

    public SingleOutputStreamOperator<T, O> disableChaining() {
        return this.setChainingStrategy(ChainingStrategy.NEVER);
    }

    public SingleOutputStreamOperator<T, O> startNewChain() {
        return this.setChainingStrategy(ChainingStrategy.HEAD);
    }

    public O returns(String typeInfoString) {
        if (typeInfoString == null) {
            throw new IllegalArgumentException("Type information string must not be null.");
        }
        return this.returns(TypeInfoParser.parse((String)typeInfoString));
    }

    public O returns(TypeInformation<T> typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Type information must not be null.");
        }
        this.transformation.setOutputType(typeInfo);
        SingleOutputStreamOperator returnType = this;
        return (O)returnType;
    }

    public O returns(Class<T> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException("Type class must not be null.");
        }
        try {
            TypeInformation ti = TypeExtractor.createTypeInfo(typeClass);
            return this.returns(ti);
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("The given class is not suited for providing necessary type information.", (Throwable)e);
        }
    }

    @Override
    protected DataStream<T> setConnectionType(StreamPartitioner<T> partitioner) {
        return new SingleOutputStreamOperator(this.getExecutionEnvironment(), new PartitionTransformation(this.getTransformation(), partitioner));
    }

    public SingleOutputStreamOperator<T, O> startNewResourceGroup() {
        this.transformation.setResourceStrategy(StreamGraph.ResourceStrategy.NEWGROUP);
        return this;
    }

    public SingleOutputStreamOperator<T, O> isolateResources() {
        this.transformation.setResourceStrategy(StreamGraph.ResourceStrategy.ISOLATE);
        return this;
    }
}

