/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.sstmerge;

import java.util.List;
import java.util.Objects;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;

class CompactionTask {
    final int level;
    final List<String> files;
    final ColumnFamilyHandle columnFamilyHandle;

    CompactionTask(int level, List<String> files, ColumnFamilyHandle columnFamilyHandle) {
        Preconditions.checkArgument((!files.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0);
        this.level = level;
        this.files = (List)Preconditions.checkNotNull(files);
        this.columnFamilyHandle = (ColumnFamilyHandle)Preconditions.checkNotNull((Object)columnFamilyHandle);
    }

    public String toString() {
        return "CompactionTask{level=" + this.level + ", files=" + String.valueOf(this.files) + ", columnFamily=" + String.valueOf(this.columnFamilyHandle) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionTask that = (CompactionTask)o;
        return this.level == that.level && Objects.equals(this.files, that.files) && Objects.equals(this.columnFamilyHandle, that.columnFamilyHandle);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.files, this.columnFamilyHandle);
    }
}

