/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.sstmerge;

import java.util.concurrent.ExecutorService;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackend;
import org.apache.flink.state.rocksdb.RocksDBProperty;
import org.apache.flink.state.rocksdb.sstmerge.ColumnFamilyLookup;
import org.apache.flink.state.rocksdb.sstmerge.CompactionScheduler;
import org.apache.flink.state.rocksdb.sstmerge.CompactionTaskProducer;
import org.apache.flink.state.rocksdb.sstmerge.CompactionTracker;
import org.apache.flink.state.rocksdb.sstmerge.Compactor;
import org.apache.flink.state.rocksdb.sstmerge.RocksDBManualCompactionConfig;
import org.apache.flink.state.rocksdb.sstmerge.RocksDBManualCompactionManager;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RocksDBManualCompactionManagerImpl
implements RocksDBManualCompactionManager {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBManualCompactionManagerImpl.class);
    private final ColumnFamilyLookup lookup = new ColumnFamilyLookup();
    private final CompactionScheduler scheduler;
    private final CompactionTracker tracker;

    public RocksDBManualCompactionManagerImpl(RocksDB db, RocksDBManualCompactionConfig settings, ExecutorService ioExecutor) {
        this.tracker = new CompactionTracker(settings, cf -> RocksDBManualCompactionManagerImpl.getNumAutoCompactions(db, cf));
        this.scheduler = new CompactionScheduler(settings, ioExecutor, new CompactionTaskProducer(db, settings, this.lookup), new Compactor(db, settings.maxOutputFileSize.getBytes()), this.tracker);
    }

    @Override
    public void start() {
        this.scheduler.start();
    }

    @Override
    public void register(RocksDBKeyedStateBackend.RocksDbKvStateInfo stateInfo) {
        LOG.debug("Register state for manual compactions: '{}'", (Object)stateInfo.metaInfo.getName());
        this.lookup.add(stateInfo.columnFamilyHandle);
    }

    @Override
    public void close() throws Exception {
        LOG.info("Stopping RocksDBManualCompactionManager");
        this.tracker.close();
        try {
            this.scheduler.stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to stop compaction scheduler {}", (Object)this.scheduler, (Object)e);
        }
    }

    private static long getNumAutoCompactions(RocksDB db, ColumnFamilyHandle columnFamily) {
        try {
            return db.getLongProperty(columnFamily, RocksDBProperty.NumRunningCompactions.getRocksDBProperty());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }
}

