/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.state.rocksdb.RocksDBSharedResources;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.WriteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBMemoryControllerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBMemoryControllerUtils.class);

    public static RocksDBSharedResources allocateRocksDBSharedResources(long totalMemorySize, double writeBufferRatio, double highPriorityPoolRatio, boolean usingPartitionedIndexFilters, RocksDBMemoryFactory factory) {
        long calculatedCacheCapacity = RocksDBMemoryControllerUtils.calculateActualCacheCapacity(totalMemorySize, writeBufferRatio);
        Cache cache = factory.createCache(calculatedCacheCapacity, highPriorityPoolRatio);
        long writeBufferManagerCapacity = RocksDBMemoryControllerUtils.calculateWriteBufferManagerCapacity(totalMemorySize, writeBufferRatio);
        WriteBufferManager wbm = factory.createWriteBufferManager(writeBufferManagerCapacity, cache);
        LOG.debug("Allocated RocksDB shared resources, calculatedCacheCapacity: {}, highPriorityPoolRatio: {}, writeBufferManagerCapacity: {}, usingPartitionedIndexFilters: {}", new Object[]{calculatedCacheCapacity, highPriorityPoolRatio, writeBufferManagerCapacity, usingPartitionedIndexFilters});
        return new RocksDBSharedResources(cache, wbm, writeBufferManagerCapacity, usingPartitionedIndexFilters);
    }

    @VisibleForTesting
    public static long calculateActualCacheCapacity(long totalMemorySize, double writeBufferRatio) {
        return (long)((3.0 - writeBufferRatio) * (double)totalMemorySize / 3.0);
    }

    @VisibleForTesting
    static long calculateWriteBufferManagerCapacity(long totalMemorySize, double writeBufferRatio) {
        return (long)((double)(2L * totalMemorySize) * writeBufferRatio / 3.0);
    }

    @VisibleForTesting
    static Cache createCache(long cacheCapacity, double highPriorityPoolRatio) {
        return new LRUCache(cacheCapacity, -1, false, highPriorityPoolRatio);
    }

    @VisibleForTesting
    static WriteBufferManager createWriteBufferManager(long writeBufferManagerCapacity, Cache cache) {
        return new WriteBufferManager(writeBufferManagerCapacity, cache);
    }

    static long calculateRocksDBDefaultArenaBlockSize(long writeBufferSize) {
        long arenaBlockSize = writeBufferSize / 8L;
        long align = 4096L;
        return (arenaBlockSize + 4096L - 1L) / 4096L * 4096L;
    }

    static long calculateRocksDBMutableLimit(long bufferSize) {
        return bufferSize * 7L / 8L;
    }

    @VisibleForTesting
    static boolean validateArenaBlockSize(long arenaBlockSize, long mutableLimit) {
        return arenaBlockSize <= mutableLimit;
    }

    public static interface RocksDBMemoryFactory
    extends Serializable {
        public static final RocksDBMemoryFactory DEFAULT = new RocksDBMemoryFactory(){

            @Override
            public Cache createCache(long cacheCapacity, double highPriorityPoolRatio) {
                return RocksDBMemoryControllerUtils.createCache(cacheCapacity, highPriorityPoolRatio);
            }

            @Override
            public WriteBufferManager createWriteBufferManager(long writeBufferManagerCapacity, Cache cache) {
                return RocksDBMemoryControllerUtils.createWriteBufferManager(writeBufferManagerCapacity, cache);
            }
        };

        public Cache createCache(long var1, double var3);

        public WriteBufferManager createWriteBufferManager(long var1, Cache var3);
    }
}

